/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.existdb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.exist.xmldb.XQueryService;
import org.jboss.security.xacml.existdb.ExistSecurityCtx;
import org.jboss.security.xacml.existdb.util.SecurityActions;
import org.jboss.security.xacml.jaxb.Option;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistDBUtil {
    public static String getOptionValue(List<Option> options, String key) {
        for (Option option : options) {
            if (!key.equals(option.getName())) continue;
            return (String)option.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStaticFileIntoString(File file) {
        InputStreamReader reader = null;
        if (!file.exists()) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String path = file.getPath();
            InputStream is = tcl.getResourceAsStream(file.getPath());
            if (is == null) {
                throw new RuntimeException("file could not be located " + path);
            }
            try {
                reader = new InputStreamReader(is, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(reader);
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(SecurityActions.getSystemProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return contents.toString();
    }

    public static Object query(Collection collection, String query) throws Exception {
        XQueryService service = (XQueryService)collection.getService("XQueryService", "1.0");
        ResourceSet result = service.query(query);
        long size = result.getSize();
        if (size > 1L) {
            throw new RuntimeException("XQuery result is greater than 1");
        }
        ResourceIterator resourceIterator = result.getIterator();
        Resource resource = resourceIterator.nextResource();
        return resource.getContent();
    }

    public static String retrieve(Collection collection, String documentName) throws Exception {
        XMLResource res = (XMLResource)collection.getResource(documentName);
        if (res == null) {
            throw new RuntimeException("Document not found in exist db:" + documentName + " in collection:" + collection.getName());
        }
        Object content = res.getContent();
        return (String)content;
    }

    public static Collection getCollection(String URI2, String collectionName, ExistSecurityCtx sctx) throws XMLDBException {
        Collection col = null;
        col = sctx != null ? DatabaseManager.getCollection((String)(URI2 + collectionName), (String)sctx.getUsername(), (String)sctx.getPassword()) : DatabaseManager.getCollection((String)(URI2 + collectionName));
        col.setProperty("indent", "no");
        col.setProperty("expand-xincludes", "no");
        col.setProperty("process-xsl-pi", "no");
        return col;
    }
}

