/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.ProjectBuilder;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.GAV;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.ProjectComparator;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.core.util.ManipulatorPriorityComparator;
import org.commonjava.maven.ext.io.PomIO;
import org.commonjava.maven.ext.io.resolver.ExtensionInfrastructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ManipulationManager {
    private static final String MARKER_PATH = "target";
    public static final String MARKER_FILE = "target" + File.separatorChar + "pom-manip-ext-marker.txt";
    public static final String RESULT_FILE = "target" + File.separatorChar + "pom-manip-ext-result.json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProjectBuilder projectBuilder;
    private Map<String, Manipulator> manipulators;
    private Map<String, ExtensionInfrastructure> infrastructure;
    private final PomIO pomIO;
    private List<Manipulator> orderedManipulators;

    @Inject
    public ManipulationManager(ProjectBuilder projectBuilder, Map<String, Manipulator> manipulators, Map<String, ExtensionInfrastructure> infrastructure, PomIO pomIO) {
        this.projectBuilder = projectBuilder;
        this.manipulators = manipulators;
        this.infrastructure = infrastructure;
        this.pomIO = pomIO;
    }

    public void init(ManipulationSession session) throws ManipulationException {
        this.logger.debug("Initialising ManipulationManager with user properties {}", (Object)session.getUserProperties());
        for (ExtensionInfrastructure infra : this.infrastructure.values()) {
            infra.init(session.getTargetDir(), session.getRemoteRepositories(), session.getLocalRepository(), session.getSettings(), session.getActiveProfiles());
        }
        this.orderedManipulators = new ArrayList<Manipulator>(this.manipulators.values());
        this.orderedManipulators.sort(Collections.reverseOrder(new ManipulatorPriorityComparator()));
        for (Manipulator manipulator : this.orderedManipulators) {
            this.logger.debug("Initialising manipulator " + manipulator.getClass().getSimpleName());
            manipulator.init(session);
        }
        this.orderedManipulators.sort(new ManipulatorPriorityComparator());
        session.setState(new CommonState(session.getUserProperties()));
    }

    public void scanAndApply(ManipulationSession session) throws ManipulationException {
        Set<Project> changed;
        List<Project> currentProjects = this.pomIO.parseProject(session.getPom());
        ArrayList<Project> originalProjects = new ArrayList<Project>();
        currentProjects.forEach(p -> originalProjects.add(new Project((Project)p)));
        session.getActiveProfiles().addAll(this.parseActiveProfiles(session, currentProjects));
        session.setProjects(currentProjects);
        if (this.logger.isDebugEnabled()) {
            for (Project project : currentProjects) {
                this.logger.debug("Got {} (POM: {})", (Object)project, (Object)project.getPom());
            }
        }
        if (!(changed = this.applyManipulations(currentProjects)).isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: Rewrite changed: {}", (Object)currentProjects);
            GAV gav = this.pomIO.rewritePOMs(changed);
            try {
                VersioningState state = session.getState(VersioningState.class);
                state.setExecutionRootModified(gav);
                new File(session.getTargetDir().getParentFile(), MARKER_PATH).mkdirs();
                new File(session.getTargetDir().getParentFile(), MARKER_FILE).createNewFile();
                try (FileWriter writer = new FileWriter(new File(session.getTargetDir().getParentFile(), RESULT_FILE));){
                    writer.write(this.collectResults(session));
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to create marker or result file", e);
                throw new ManipulationException("Marker/result file creation failed", (Throwable)e, new Object[0]);
            }
            ProjectComparator.compareProjects(session, originalProjects, currentProjects);
        }
        for (ExtensionInfrastructure e : this.infrastructure.values()) {
            e.finish();
        }
        this.logger.info("Maven-Manipulation-Extension: Finished.");
    }

    private Set<String> parseActiveProfiles(ManipulationSession session, List<Project> projects) throws ManipulationException {
        HashSet<String> activeProfiles = new HashSet<String>();
        DefaultProfileManager dpm = new DefaultProfileManager(session.getSession().getContainer(), session.getUserProperties());
        for (Project p : projects) {
            p.getModel().getProfiles().stream().filter(newProfile -> !dpm.getProfilesById().containsKey(newProfile.getId())).forEach(newProfile -> dpm.addProfile(newProfile.clone()));
            try {
                List ap = dpm.getActiveProfiles();
                activeProfiles.addAll(ap.stream().map(Profile::getId).collect(Collectors.toList()));
            }
            catch (ProfileActivationException e) {
                throw new ManipulationException("Activation detection failure", (Throwable)e, new Object[0]);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Will {}scan all profiles and returning active profiles of {} ", (Object)(Boolean.parseBoolean(session.getUserProperties().getProperty("scanActiveProfiles", ProfileUtils.PROFILE_SCANNING_DEFAULT)) ? "not " : ""), (Object)activeProfiles);
        }
        return activeProfiles;
    }

    private Set<Project> applyManipulations(List<Project> projects) throws ManipulationException {
        HashSet<Project> changed = new HashSet<Project>();
        for (Manipulator manipulator : this.orderedManipulators) {
            Set<Project> mChanged = manipulator.applyChanges(projects);
            if (mChanged == null) continue;
            changed.addAll(mChanged);
        }
        if (changed.isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: No changes.");
        }
        return changed;
    }

    private String collectResults(ManipulationSession session) throws JsonProcessingException {
        ObjectMapper MAPPER = new ObjectMapper();
        Object vc = MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility((VisibilityChecker<?>)vc);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ObjectNode root = MAPPER.createObjectNode();
        for (Map.Entry<Class<?>, State> stateEntry : session.getStatesCopy()) {
            JsonNode node = MAPPER.convertValue((Object)stateEntry.getValue(), JsonNode.class);
            if (!node.isObject() || node.size() == 0) continue;
            root.set(stateEntry.getKey().getSimpleName(), node);
        }
        return MAPPER.writeValueAsString(root);
    }
}

