/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONState
implements State {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String JSON_PROPERTY = "jsonUpdate";
    private final List<JSONOperation> jsonOperations = new ArrayList<JSONOperation>();

    public JSONState(Properties userProps) throws ManipulationException {
        String property = userProps.getProperty(JSON_PROPERTY);
        if (StringUtils.isNotEmpty(property)) {
            String[] ops = property.split("(?<!\\\\),");
            for (int i = 0; i < ops.length; ++i) {
                ops[i] = ops[i].replaceAll("\\\\,", ",");
            }
            for (String operation : ops) {
                String[] components = operation.split("(?<!\\\\):", 3);
                for (int i = 0; i < components.length; ++i) {
                    components[i] = components[i].replaceAll("\\\\:", ":");
                }
                if (components.length != 3) {
                    throw new ManipulationException("Unable to parse command " + operation + " from property " + property, new String[0]);
                }
                this.logger.debug("Adding JSONOperation with file {}, xpath {} and update {}", components[0], components[1], components[2]);
                this.jsonOperations.add(new JSONOperation(components[0], components[1], components[2]));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.jsonOperations != null && !this.jsonOperations.isEmpty();
    }

    public List<JSONOperation> getJSONOperations() {
        return this.jsonOperations;
    }

    public static final class JSONOperation {
        private String file;
        private String xpath;
        private String update;

        public JSONOperation(String file, String xpath, String update) {
            this.file = file;
            this.xpath = xpath;
            this.update = update;
        }

        public String getFile() {
            return this.file;
        }

        public String getXPath() {
            return this.xpath;
        }

        public String getUpdate() {
            return this.update;
        }

        public String toString() {
            return "File " + this.file + " xpath '" + this.xpath + "' update " + this.update;
        }
    }
}

