/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.settings.Settings;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.io.resolver.ExtensionInfrastructure;
import org.commonjava.maven.ext.io.resolver.MavenLocationExpander;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.auth.MemoryPasswordManager;
import org.commonjava.maven.galley.cache.FileCacheProvider;
import org.commonjava.maven.galley.config.TransportManagerConfig;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.NoOpFileEventManager;
import org.commonjava.maven.galley.filearc.FileTransport;
import org.commonjava.maven.galley.filearc.ZipJarTransport;
import org.commonjava.maven.galley.internal.TransferManagerImpl;
import org.commonjava.maven.galley.internal.xfer.DownloadHandler;
import org.commonjava.maven.galley.internal.xfer.ExistenceHandler;
import org.commonjava.maven.galley.internal.xfer.ListingHandler;
import org.commonjava.maven.galley.internal.xfer.UploadHandler;
import org.commonjava.maven.galley.io.HashedLocationPathGenerator;
import org.commonjava.maven.galley.io.NoOpTransferDecorator;
import org.commonjava.maven.galley.io.SpecialPathManagerImpl;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.internal.ArtifactManagerImpl;
import org.commonjava.maven.galley.maven.internal.ArtifactMetadataManagerImpl;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMaven350PluginDefaults;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMavenPluginImplications;
import org.commonjava.maven.galley.maven.internal.type.StandardTypeMapper;
import org.commonjava.maven.galley.maven.internal.version.VersionResolverImpl;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.util.ArtifactPathUtils;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.nfc.MemoryNotFoundCache;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.transport.TransportManagerImpl;
import org.commonjava.maven.galley.transport.htcli.HttpClientTransport;
import org.commonjava.maven.galley.transport.htcli.HttpImpl;

@Named(value="galley")
@Singleton
public class GalleyInfrastructure
implements ExtensionInfrastructure {
    private static final String LOCAL_REPO_SCANNING_PROP = "manipulator.local.repo.scanning";
    private MirrorSelector mirrorSelector;
    private MavenPomReader pomReader;
    private ArtifactManager artifactManager;
    private MavenMetadataReader metadataReader;
    private XMLInfrastructure xml;
    private XPathManager xpaths;
    private ExecutorService executor;
    private MavenSessionHandler sessionHandler;
    private File cacheDir;

    public File getCacheDir() {
        return this.cacheDir;
    }

    @Inject
    public GalleyInfrastructure(MavenSessionHandler session, MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        this.sessionHandler = session;
    }

    public GalleyInfrastructure(File targetDirectory, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, Settings settings, List<String> activeProfiles) throws ManipulationException {
        this.init(targetDirectory, remoteRepositories, localRepository, settings, activeProfiles);
    }

    public GalleyInfrastructure(File targetDirectory, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, Settings settings, List<String> activeProfiles, MirrorSelector mirrorSelector, Location customLocation, Transport customTransport, File cacheDir) throws ManipulationException {
        this.mirrorSelector = mirrorSelector;
        this.init(targetDirectory, remoteRepositories, localRepository, settings, activeProfiles, customLocation, customTransport, cacheDir);
    }

    @Override
    public void init(File targetDirectory, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, Settings settings, List<String> activeProfiles) throws ManipulationException {
        this.init(targetDirectory, remoteRepositories, localRepository, settings, activeProfiles, null, null, null);
    }

    private void init(File targetDirectory, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, Settings settings, List<String> activeProfiles, Location customLocation, Transport customTransport, File cacheDir_) throws ManipulationException {
        MavenLocationExpander locationExpander;
        try {
            List<Location> custom = customLocation == null ? Collections.emptyList() : Collections.singletonList(customLocation);
            locationExpander = new MavenLocationExpander(custom, remoteRepositories, localRepository, this.mirrorSelector, settings, activeProfiles);
        }
        catch (MalformedURLException e) {
            throw new ManipulationException("Failed to setup Maven-specific LocationExpander: %s", (Throwable)e, e.getMessage());
        }
        this.xml = new XMLInfrastructure();
        this.xpaths = new XPathManager();
        TransportManagerImpl transports = customTransport != null ? new TransportManagerImpl(customTransport) : new TransportManagerImpl(new HttpClientTransport(new HttpImpl(new MemoryPasswordManager())), new FileTransport(), new ZipJarTransport());
        this.cacheDir = cacheDir_;
        if (this.cacheDir == null) {
            this.cacheDir = new File(targetDirectory, "manipulator-cache");
        }
        NoOpFileEventManager fileEvents = new NoOpFileEventManager();
        FileCacheProvider cache = new FileCacheProvider(this.cacheDir, (PathGenerator)new HashedLocationPathGenerator(), (FileEventManager)fileEvents, (TransferDecorator)new NoOpTransferDecorator());
        MemoryNotFoundCache nfc = new MemoryNotFoundCache();
        this.executor = Executors.newCachedThreadPool();
        TransportManagerConfig config = new TransportManagerConfig();
        final TransferManagerImpl transfers = new TransferManagerImpl(transports, cache, nfc, fileEvents, new DownloadHandler(nfc, config, this.executor), new UploadHandler(nfc, config, this.executor), new ListingHandler(nfc), new ExistenceHandler(nfc), new SpecialPathManagerImpl(), this.executor);
        StandardTypeMapper types = new StandardTypeMapper();
        ArtifactMetadataManagerImpl metadataManager = new ArtifactMetadataManagerImpl(transfers, locationExpander){

            @Override
            public List<Transfer> retrieveAll(List<? extends Location> locations, String groupId, String filename, EventMetadata eventMetadata) throws TransferException {
                if (GalleyInfrastructure.this.localMetadataScanningEnabled()) {
                    ArrayList<ConcreteResource> resources = new ArrayList<ConcreteResource>();
                    for (Location l : locationExpander.expand(locations)) {
                        String p = l.getUri().startsWith("file:") ? ArtifactPathUtils.formatMetadataPath(groupId, "maven-metadata-local.xml") : ArtifactPathUtils.formatMetadataPath(groupId, filename);
                        resources.add(new ConcreteResource(l, p));
                    }
                    return transfers.retrieveAll(new VirtualResource(resources), eventMetadata);
                }
                return super.retrieveAll(locations, groupId, filename, eventMetadata);
            }

            @Override
            public List<Transfer> retrieveAll(List<? extends Location> locations, ProjectRef ref, String filename, EventMetadata eventMetadata) throws TransferException {
                if (GalleyInfrastructure.this.localMetadataScanningEnabled()) {
                    ArrayList<ConcreteResource> resources = new ArrayList<ConcreteResource>();
                    for (Location l : locationExpander.expand(locations)) {
                        String p = l.getUri().startsWith("file:") ? ArtifactPathUtils.formatMetadataPath(ref, "maven-metadata-local.xml") : ArtifactPathUtils.formatMetadataPath(ref, filename);
                        resources.add(new ConcreteResource(l, p));
                    }
                    return transfers.retrieveAll(new VirtualResource(resources), eventMetadata);
                }
                return super.retrieveAll(locations, ref, filename, eventMetadata);
            }
        };
        VersionResolverImpl versionResolver = new VersionResolverImpl(new MavenMetadataReader(this.xml, locationExpander, metadataManager, this.xpaths));
        this.artifactManager = new ArtifactManagerImpl(transfers, locationExpander, types, versionResolver);
        StandardMaven350PluginDefaults pluginDefaults = new StandardMaven350PluginDefaults();
        StandardMavenPluginImplications pluginImplications = new StandardMavenPluginImplications(this.xml);
        this.pomReader = new MavenPomReader(this.xml, locationExpander, this.artifactManager, this.xpaths, pluginDefaults, pluginImplications);
        this.metadataReader = new MavenMetadataReader(this.xml, locationExpander, metadataManager, this.xpaths);
    }

    private boolean localMetadataScanningEnabled() {
        return this.sessionHandler == null ? true : Boolean.valueOf(this.sessionHandler.getUserProperties().getProperty(LOCAL_REPO_SCANNING_PROP, "true"));
    }

    public MavenPomReader getPomReader() {
        return this.pomReader;
    }

    public XMLInfrastructure getXml() {
        return this.xml;
    }

    public MavenMetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public XPathManager getXPath() {
        return this.xpaths;
    }

    @Override
    public void finish() {
        this.executor.shutdown();
    }
}

