/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.commonjava.util.jhttpc.model.SiteConfig;

public class SiteConnectionConfig {
    private final SiteConfig config;
    private PlainConnectionSocketFactory httpFactory = PlainConnectionSocketFactory.getSocketFactory();
    private SSLConnectionSocketFactory sslFactory = SSLConnectionSocketFactory.getSocketFactory();

    public SiteConnectionConfig(SiteConfig config) {
        this.config = config;
    }

    public SiteConnectionConfig withSSLConnectionSocketFactory(SSLConnectionSocketFactory factory) {
        if (factory != null) {
            this.sslFactory = factory;
        }
        return this;
    }

    public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
        return RegistryBuilder.create().register("http", (Object)this.httpFactory).register("https", (Object)this.sslFactory).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiteConnectionConfig)) {
            return false;
        }
        SiteConnectionConfig that = (SiteConnectionConfig)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public String toString() {
        return "SiteConnectionConfig{config=" + this.config + ", sslFactory=" + this.sslFactory + '}';
    }

    public int getMaxConnections() {
        return this.config.getMaxConnections();
    }

    public String getId() {
        return this.config.getId();
    }
}

