/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.SimpleLruCache;
import org.eclipse.jgit.util.Stats;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS.class);
    protected static final WorkingTreeIterator.Entry[] NO_ENTRIES = new WorkingTreeIterator.Entry[0];
    public static final FS DETECTED = FS.detect();
    private static volatile FSFactory factory;
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitSystemConfig;

    public static FS detect() {
        return FS.detect(null);
    }

    public static void setAsyncFileStoreAttributes(boolean asynch) {
        FileStoreAttributes.setBackground(asynch);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (factory == null) {
            factory = new FSFactory();
        }
        return factory.detect(cygwinUsed);
    }

    public static FileStoreAttributes getFileStoreAttributes(@NonNull Path dir) {
        return FileStoreAttributes.get(dir);
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitSystemConfig = src.gitSystemConfig;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsAtomicCreateNewFile() {
        return true;
    }

    public boolean supportsSymlinks() {
        return false;
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    @Deprecated
    public long lastModified(File f) throws IOException {
        return FileUtils.lastModified(f);
    }

    public Instant lastModifiedInstant(Path p) {
        return FileUtils.lastModifiedInstant(p);
    }

    public Instant lastModifiedInstant(File f) {
        return FileUtils.lastModifiedInstant(f.toPath());
    }

    @Deprecated
    public void setLastModified(File f, long time) throws IOException {
        FileUtils.setLastModified(f, time);
    }

    public void setLastModified(Path p, Instant time) throws IOException {
        FileUtils.setLastModified(p, time);
    }

    public long length(File path) throws IOException {
        return FileUtils.getLength(path);
    }

    public void delete(File f) throws IOException {
        FileUtils.delete(f);
    }

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path) {
        this.userHome = new Holder<File>(path);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    public BasicFileAttributes fileAttributes(File file) throws IOException {
        return FileUtils.fileAttributes(file);
    }

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(() -> System.getProperty("user.home"));
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    protected static File searchPath(String path, String ... lookFor) {
        if (path == null) {
            return null;
        }
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String[] stringArray2 = lookFor;
            int n3 = lookFor.length;
            int n4 = 0;
            while (n4 < n3) {
                String command = stringArray2[n4];
                File e = new File(p, command);
                if (e.isFile()) {
                    return e.getAbsoluteFile();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    protected static String readPipe(File dir, String[] command, String encoding) throws CommandFailedException {
        return FS.readPipe(dir, command, encoding, null);
    }

    @Nullable
    protected static String readPipe(File dir, String[] command, String encoding, Map<String, String> env) throws CommandFailedException {
        boolean debug = LOG.isDebugEnabled();
        try {
            Process p;
            if (debug) {
                LOG.debug("readpipe " + Arrays.asList(command) + "," + dir);
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(dir);
            if (env != null) {
                pb.environment().putAll(env);
            }
            try {
                p = pb.start();
            }
            catch (IOException e) {
                throw new CommandFailedException(-1, e.getMessage(), e);
            }
            p.getOutputStream().close();
            GobblerThread gobbler = new GobblerThread(p, command, dir);
            gobbler.start();
            String r = null;
            Throwable throwable = null;
            Object var10_15 = null;
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));){
                r = lineRead.readLine();
                if (debug) {
                    String l;
                    LOG.debug("readpipe may return '" + r + "'");
                    LOG.debug("remaining output:\n");
                    while ((l = lineRead.readLine()) != null) {
                        LOG.debug(l);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            while (true) {
                try {
                    int rc = p.waitFor();
                    gobbler.join();
                    if (rc == 0 && !gobbler.fail.get()) {
                        return r;
                    }
                    if (debug) {
                        LOG.debug("readpipe rc=" + rc);
                    }
                    throw new CommandFailedException(rc, gobbler.errorMessage.get(), gobbler.exception.get());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Caught exception in FS.readPipe()", e);
            if (debug) {
                LOG.debug("readpipe returns null");
            }
            return null;
        }
    }

    protected abstract File discoverGitExe();

    protected File discoverGitSystemConfig() {
        String w;
        String v;
        File gitExe = this.discoverGitExe();
        if (gitExe == null) {
            return null;
        }
        try {
            v = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "--version"}, Charset.defaultCharset().name());
        }
        catch (CommandFailedException e) {
            LOG.warn(e.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(v) || v != null && v.startsWith("jgit")) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GIT_EDITOR", "echo");
        try {
            w = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "config", "--system", "--edit"}, Charset.defaultCharset().name(), env);
        }
        catch (CommandFailedException e) {
            LOG.warn(e.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(w)) {
            return null;
        }
        return new File(w);
    }

    public File getGitSystemConfig() {
        if (this.gitSystemConfig == null) {
            this.gitSystemConfig = new Holder<File>(this.discoverGitSystemConfig());
        }
        return (File)this.gitSystemConfig.value;
    }

    public FS setGitSystemConfig(File configFile) {
        this.gitSystemConfig = new Holder<File>(configFile);
        return this;
    }

    protected static File resolveGrandparentFile(File grandchild) {
        File parent;
        if (grandchild != null && (parent = grandchild.getParentFile()) != null) {
            return parent.getParentFile();
        }
        return null;
    }

    public String readSymLink(File path) throws IOException {
        return FileUtils.readSymLink(path);
    }

    public boolean isSymLink(File path) throws IOException {
        return FileUtils.isSymlink(path);
    }

    public boolean exists(File path) {
        return FileUtils.exists(path);
    }

    public boolean isDirectory(File path) {
        return FileUtils.isDirectory(path);
    }

    public boolean isFile(File path) {
        return FileUtils.isFile(path);
    }

    public boolean isHidden(File path) throws IOException {
        return FileUtils.isHidden(path);
    }

    public void setHidden(File path, boolean hidden) throws IOException {
        FileUtils.setHidden(path, hidden);
    }

    public void createSymLink(File path, String target) throws IOException {
        FileUtils.createSymLink(path, target);
    }

    @Deprecated
    public boolean createNewFile(File path) throws IOException {
        return path.createNewFile();
    }

    public LockToken createNewFileAtomic(File path) throws IOException {
        return new LockToken(path.createNewFile(), Optional.empty());
    }

    public String relativize(String base, String other) {
        return FileUtils.relativizePath(base, other, File.separator, this.isCaseSensitive());
    }

    public WorkingTreeIterator.Entry[] list(File directory, FileTreeIterator.FileModeStrategy fileModeStrategy) {
        File[] all = directory.listFiles();
        if (all == null) {
            return NO_ENTRIES;
        }
        WorkingTreeIterator.Entry[] result = new WorkingTreeIterator.Entry[all.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new FileTreeIterator.FileEntry(all[i], this, fileModeStrategy);
            ++i;
        }
        return result;
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args) throws JGitInternalException {
        return this.runHookIfPresent(repository, hookName, args, System.out, System.err, null);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return new ProcessResult(ProcessResult.Status.NOT_SUPPORTED);
    }

    protected ProcessResult internalRunHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        File hookFile = this.findHook(repository, hookName);
        if (hookFile == null) {
            return new ProcessResult(ProcessResult.Status.NOT_PRESENT);
        }
        String hookPath = hookFile.getAbsolutePath();
        File runDirectory = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        String cmd = this.relativize(runDirectory.getAbsolutePath(), hookPath);
        ProcessBuilder hookProcess = this.runInShell(cmd, args);
        hookProcess.directory(runDirectory);
        Map<String, String> environment = hookProcess.environment();
        environment.put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        if (!repository.isBare()) {
            environment.put("GIT_WORK_TREE", repository.getWorkTree().getAbsolutePath());
        }
        try {
            return new ProcessResult(this.runProcess(hookProcess, (OutputStream)outRedirect, (OutputStream)errRedirect, stdinArgs), ProcessResult.Status.OK);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, hookName), e);
        }
        catch (InterruptedException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, hookName), e);
        }
    }

    public File findHook(Repository repository, String hookName) {
        File gitDir = repository.getDirectory();
        if (gitDir == null) {
            return null;
        }
        File hookFile = new File(new File(gitDir, "hooks"), hookName);
        return hookFile.isFile() ? hookFile : null;
    }

    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws IOException, InterruptedException {
        ByteArrayInputStream in = stdinArgs == null ? null : new ByteArrayInputStream(stdinArgs.getBytes(StandardCharsets.UTF_8));
        return this.runProcess(processBuilder, outRedirect, errRedirect, in);
    }

    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, InputStream inRedirect) throws IOException, InterruptedException {
        IOException ioException;
        block42: {
            int n;
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Process process = null;
            ioException = null;
            try {
                process = processBuilder.start();
                executor.execute(new StreamGobbler(process.getErrorStream(), errRedirect));
                executor.execute(new StreamGobbler(process.getInputStream(), outRedirect));
                OutputStream outputStream = process.getOutputStream();
                try {
                    if (inRedirect != null) {
                        new StreamGobbler(inRedirect, outputStream).copy();
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                n = process.waitFor();
            }
            catch (IOException e) {
                try {
                    ioException = e;
                }
                catch (Throwable throwable) {
                    FS.shutdownAndAwaitTermination(executor);
                    if (process != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException e2) {
                            Thread.interrupted();
                        }
                        if (inRedirect != null) {
                            inRedirect.close();
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException e3) {
                            ioException = ioException != null ? ioException : e3;
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e4) {
                            ioException = ioException != null ? ioException : e4;
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException e5) {
                            ioException = ioException != null ? ioException : e5;
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                FS.shutdownAndAwaitTermination(executor);
                if (process == null) break block42;
                try {
                    process.waitFor();
                }
                catch (InterruptedException e6) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e7) {
                    ioException = ioException != null ? ioException : e7;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e8) {
                    ioException = ioException != null ? ioException : e8;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e9) {
                    ioException = ioException != null ? ioException : e9;
                }
                process.destroy();
            }
            FS.shutdownAndAwaitTermination(executor);
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                process.destroy();
            }
            return n;
        }
        throw ioException;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean hasShutdown = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    hasShutdown = false;
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            hasShutdown = false;
        }
        return hasShutdown;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    /*
     * Loose catch block
     */
    public ExecutionResult execute(ProcessBuilder pb, InputStream in) throws IOException, InterruptedException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ExecutionResult executionResult;
            TemporaryBuffer.Heap stderr;
            TemporaryBuffer.LocalFile stdout;
            block16: {
                block15: {
                    stdout = new TemporaryBuffer.LocalFile(null);
                    stderr = new TemporaryBuffer.Heap(1024, 0x100000);
                    int rc = this.runProcess(pb, (OutputStream)stdout, (OutputStream)stderr, in);
                    executionResult = new ExecutionResult(stdout, stderr, rc);
                    if (stderr == null) break block15;
                    stderr.close();
                }
                if (stdout == null) break block16;
                stdout.close();
            }
            return executionResult;
            {
                catch (Throwable throwable2) {
                    try {
                        if (stderr != null) {
                            stderr.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stdout != null) {
                            stdout.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public Attributes getAttributes(File path) {
        boolean isFile;
        boolean isDirectory = this.isDirectory(path);
        boolean bl = isFile = !isDirectory && path.isFile();
        assert (path.exists() == isDirectory || isFile);
        boolean exists = isDirectory || isFile;
        boolean canExecute = exists && !isDirectory && this.canExecute(path);
        boolean isSymlink = false;
        Instant lastModified = exists ? this.lastModifiedInstant(path) : Instant.EPOCH;
        long createTime = 0L;
        return new Attributes(this, path, exists, isDirectory, canExecute, isSymlink, isFile, createTime, lastModified, -1L);
    }

    public File normalize(File file) {
        return file;
    }

    public String normalize(String name) {
        return name;
    }

    public static class Attributes {
        private final boolean isDirectory;
        private final boolean isSymbolicLink;
        private final boolean isRegularFile;
        private final long creationTime;
        private final Instant lastModifiedInstant;
        private final boolean isExecutable;
        private final File file;
        private final boolean exists;
        protected long length = -1L;
        final FS fs;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        @Deprecated
        public long getLastModifiedTime() {
            return this.lastModifiedInstant.toEpochMilli();
        }

        public Instant getLastModifiedInstant() {
            return this.lastModifiedInstant;
        }

        Attributes(FS fs, File file, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, Instant lastModifiedInstant, long length) {
            this.fs = fs;
            this.file = file;
            this.exists = exists;
            this.isDirectory = isDirectory;
            this.isExecutable = isExecutable;
            this.isSymbolicLink = isSymbolicLink;
            this.isRegularFile = isRegularFile;
            this.creationTime = creationTime;
            this.lastModifiedInstant = lastModifiedInstant;
            this.length = length;
        }

        public Attributes(File path, FS fs) {
            this(fs, path, false, false, false, false, false, 0L, Instant.EPOCH, 0L);
        }

        public long getLength() {
            if (this.length == -1L) {
                this.length = this.file.length();
                return this.length;
            }
            return this.length;
        }

        public String getName() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        boolean exists() {
            return this.exists;
        }
    }

    public static class ExecutionResult {
        private TemporaryBuffer stdout;
        private TemporaryBuffer stderr;
        private int rc;

        public ExecutionResult(TemporaryBuffer stdout, TemporaryBuffer stderr, int rc) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.rc = rc;
        }

        public TemporaryBuffer getStdout() {
            return this.stdout;
        }

        public TemporaryBuffer getStderr() {
            return this.stderr;
        }

        public int getRc() {
            return this.rc;
        }
    }

    public static class FSFactory {
        protected FSFactory() {
        }

        public FS detect(Boolean cygwinUsed) {
            if (SystemReader.getInstance().isWindows()) {
                if (cygwinUsed == null) {
                    cygwinUsed = FS_Win32_Cygwin.isCygwin();
                }
                if (cygwinUsed.booleanValue()) {
                    return new FS_Win32_Cygwin();
                }
                return new FS_Win32();
            }
            return new FS_POSIX();
        }
    }

    public static final class FileStoreAttributes {
        private static final Duration UNDEFINED_DURATION = Duration.ofNanos(Long.MAX_VALUE);
        public static final Duration FALLBACK_TIMESTAMP_RESOLUTION = Duration.ofMillis(2000L);
        public static final FileStoreAttributes FALLBACK_FILESTORE_ATTRIBUTES = new FileStoreAttributes(FALLBACK_TIMESTAMP_RESOLUTION);
        private static final Map<FileStore, FileStoreAttributes> attributeCache = new ConcurrentHashMap<FileStore, FileStoreAttributes>();
        private static final SimpleLruCache<Path, FileStoreAttributes> attrCacheByPath = new SimpleLruCache(100, 0.2f);
        private static AtomicBoolean background = new AtomicBoolean();
        private static Map<FileStore, Lock> locks = new ConcurrentHashMap<FileStore, Lock>();
        private static final String javaVersionPrefix = String.valueOf(System.getProperty("java.vendor")) + '|' + System.getProperty("java.version") + '|';
        private static final Duration FALLBACK_MIN_RACY_INTERVAL = Duration.ofMillis(10L);
        @NonNull
        private final Duration fsTimestampResolution;
        private Duration minimalRacyInterval;

        private static void setBackground(boolean async) {
            background.set(async);
        }

        public static void configureAttributesPathCache(int maxSize, float purgeFactor) {
            attrCacheByPath.configure(maxSize, purgeFactor);
        }

        public static FileStoreAttributes get(Path path) {
            Path dir = Files.isDirectory(path = path.toAbsolutePath(), new LinkOption[0]) ? path : path.getParent();
            FileStoreAttributes cached = attrCacheByPath.get(dir);
            if (cached != null) {
                return cached;
            }
            FileStoreAttributes attrs = FileStoreAttributes.getFileStoreAttributes(dir);
            attrCacheByPath.put(dir, attrs);
            return attrs;
        }

        private static FileStoreAttributes getFileStoreAttributes(Path dir) {
            try {
                Optional d;
                FileStore s;
                if (Files.exists(dir, new LinkOption[0])) {
                    s = Files.getFileStore(dir);
                    FileStoreAttributes c = attributeCache.get(s);
                    if (c != null) {
                        return c;
                    }
                    if (!Files.isWritable(dir)) {
                        LOG.debug("{}: cannot measure timestamp resolution in read-only directory {}", (Object)Thread.currentThread(), (Object)dir);
                        return FALLBACK_FILESTORE_ATTRIBUTES;
                    }
                } else {
                    LOG.debug("{}: cannot measure timestamp resolution of unborn directory {}", (Object)Thread.currentThread(), (Object)dir);
                    return FALLBACK_FILESTORE_ATTRIBUTES;
                }
                CompletionStage f = CompletableFuture.supplyAsync(() -> {
                    Lock lock = locks.computeIfAbsent(s, l -> new ReentrantLock());
                    if (!lock.tryLock()) {
                        LOG.debug("{}: couldn't get lock to measure timestamp resolution in {}", (Object)Thread.currentThread(), (Object)dir);
                        return Optional.empty();
                    }
                    Optional<Object> attributes = Optional.empty();
                    try {
                        FileStoreAttributes c = attributeCache.get(s);
                        if (c != null) {
                            Optional<FileStoreAttributes> optional = Optional.of(c);
                            return optional;
                        }
                        attributes = FileStoreAttributes.readFromConfig(s);
                        if (attributes.isPresent()) {
                            attributeCache.put(s, (FileStoreAttributes)attributes.get());
                            Optional<Object> optional = attributes;
                            return optional;
                        }
                        Optional<Duration> resolution = FileStoreAttributes.measureFsTimestampResolution(s, dir);
                        if (resolution.isPresent()) {
                            c = new FileStoreAttributes(resolution.get());
                            attributeCache.put(s, c);
                            if (c.fsTimestampResolution.toNanos() < 100000000L) {
                                c.minimalRacyInterval = FileStoreAttributes.measureMinimalRacyInterval(dir);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(c.toString());
                            }
                            FileStoreAttributes.saveToConfig(s, c);
                        }
                        attributes = Optional.of(c);
                    }
                    finally {
                        lock.unlock();
                        locks.remove(s);
                    }
                    return attributes;
                });
                f = ((CompletableFuture)f).exceptionally(e -> {
                    LOG.error(e.getLocalizedMessage(), (Throwable)e);
                    return Optional.empty();
                });
                Optional optional = d = background.get() ? (Optional)((CompletableFuture)f).get(100L, TimeUnit.MILLISECONDS) : (Optional)((CompletableFuture)f).get();
                if (d.isPresent()) {
                    return (FileStoreAttributes)d.get();
                }
            }
            catch (IOException | InterruptedException | CancellationException | ExecutionException e2) {
                LOG.error(e2.getMessage(), e2);
            }
            catch (SecurityException | TimeoutException exception) {
                // empty catch block
            }
            LOG.debug("{}: use fallback timestamp resolution for directory {}", (Object)Thread.currentThread(), (Object)dir);
            return FALLBACK_FILESTORE_ATTRIBUTES;
        }

        private static Duration measureMinimalRacyInterval(Path dir) {
            LOG.debug("{}: start measure minimal racy interval in {}", (Object)Thread.currentThread(), (Object)dir);
            int n = 0;
            int failures = 0;
            long racyNanos = 0L;
            ArrayList<Long> deltas = new ArrayList<Long>();
            Path probe = dir.resolve(".probe-" + UUID.randomUUID());
            Instant end = Instant.now().plusSeconds(3L);
            try {
                try {
                    Files.createFile(probe, new FileAttribute[0]);
                    do {
                        ++n;
                        FileStoreAttributes.write(probe, "a");
                        FileSnapshot snapshot = FileSnapshot.save(probe.toFile());
                        FileStoreAttributes.read(probe);
                        FileStoreAttributes.write(probe, "b");
                        if (snapshot.isModified(probe.toFile())) continue;
                        deltas.add(snapshot.lastDelta());
                        racyNanos = snapshot.lastRacyThreshold();
                        ++failures;
                    } while (Instant.now().compareTo(end) < 0);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                    Duration duration = FALLBACK_MIN_RACY_INTERVAL;
                    FileStoreAttributes.deleteProbe(probe);
                    return duration;
                }
            }
            finally {
                FileStoreAttributes.deleteProbe(probe);
            }
            if (failures > 0) {
                Stats stats = new Stats();
                for (Long d : deltas) {
                    stats.add(d.longValue());
                }
                LOG.debug("delta [ns] since modification FileSnapshot failed to detect\ncount, failures, racy limit [ns], delta min [ns], delta max [ns], delta avg [ns], delta stddev [ns]\n{}, {}, {}, {}, {}, {}, {}", n, failures, racyNanos, stats.min(), stats.max(), stats.avg(), stats.stddev());
                return Duration.ofNanos(Double.valueOf(stats.max()).longValue());
            }
            LOG.debug("{}: no failures when measuring minimal racy interval", (Object)Thread.currentThread());
            return Duration.ZERO;
        }

        private static void write(Path p, String body) throws IOException {
            FileUtils.mkdirs(p.getParent().toFile(), true);
            Throwable throwable = null;
            Object var3_4 = null;
            try (OutputStreamWriter w = new OutputStreamWriter(Files.newOutputStream(p, new OpenOption[0]), StandardCharsets.UTF_8);){
                w.write(body);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private static String read(Path p) throws IOException {
            byte[] body = IO.readFully(p.toFile());
            return new String(body, 0, body.length, StandardCharsets.UTF_8);
        }

        private static Optional<Duration> measureFsTimestampResolution(FileStore s, Path dir) {
            LOG.debug("{}: start measure timestamp resolution {} in {}", Thread.currentThread(), s, dir);
            Path probe = dir.resolve(".probe-" + UUID.randomUUID());
            try {
                FileTime t1;
                Files.createFile(probe, new FileAttribute[0]);
                FileTime t2 = t1 = Files.getLastModifiedTime(probe, new LinkOption[0]);
                Instant t1i = t1.toInstant();
                long i = 1L;
                while (t2.compareTo(t1) <= 0) {
                    Files.setLastModifiedTime(probe, FileTime.from(t1i.plusNanos(i * 1000L)));
                    t2 = Files.getLastModifiedTime(probe, new LinkOption[0]);
                    i += 1L + i / 20L;
                }
                Duration fsResolution = Duration.between(t1.toInstant(), t2.toInstant());
                Duration clockResolution = FileStoreAttributes.measureClockResolution();
                fsResolution = fsResolution.plus(clockResolution);
                LOG.debug("{}: end measure timestamp resolution {} in {}", Thread.currentThread(), s, dir);
                Optional<Duration> optional = Optional.of(fsResolution);
                return optional;
            }
            catch (AccessDeniedException e) {
                LOG.warn(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                LOG.error(e.getLocalizedMessage(), e);
            }
            finally {
                FileStoreAttributes.deleteProbe(probe);
            }
            return Optional.empty();
        }

        private static Duration measureClockResolution() {
            Duration clockResolution = Duration.ZERO;
            int i = 0;
            while (i < 10) {
                Instant t1;
                Instant t2 = t1 = Instant.now();
                while (t2.compareTo(t1) <= 0) {
                    t2 = Instant.now();
                }
                Duration r = Duration.between(t1, t2);
                if (r.compareTo(clockResolution) > 0) {
                    clockResolution = r;
                }
                ++i;
            }
            return clockResolution;
        }

        private static void deleteProbe(Path probe) {
            try {
                FileUtils.delete(probe.toFile(), 6);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }

        private static Optional<FileStoreAttributes> readFromConfig(FileStore s) {
            StoredConfig userConfig;
            try {
                userConfig = SystemReader.getInstance().getUserConfig();
            }
            catch (IOException | ConfigInvalidException e) {
                LOG.error(JGitText.get().readFileStoreAttributesFailed, e);
                return Optional.empty();
            }
            String key = FileStoreAttributes.getConfigKey(s);
            Duration resolution = Duration.ofNanos(userConfig.getTimeUnit("filesystem", key, "timestampResolution", UNDEFINED_DURATION.toNanos(), TimeUnit.NANOSECONDS));
            if (UNDEFINED_DURATION.equals(resolution)) {
                return Optional.empty();
            }
            Duration minRacyThreshold = Duration.ofNanos(userConfig.getTimeUnit("filesystem", key, "minRacyThreshold", UNDEFINED_DURATION.toNanos(), TimeUnit.NANOSECONDS));
            FileStoreAttributes c = new FileStoreAttributes(resolution);
            if (!UNDEFINED_DURATION.equals(minRacyThreshold)) {
                c.minimalRacyInterval = minRacyThreshold;
            }
            return Optional.of(c);
        }

        private static void saveToConfig(FileStore s, FileStoreAttributes c) {
            StoredConfig userConfig;
            try {
                userConfig = SystemReader.getInstance().getUserConfig();
            }
            catch (IOException | ConfigInvalidException e) {
                LOG.error(JGitText.get().saveFileStoreAttributesFailed, e);
                return;
            }
            long resolution = c.getFsTimestampResolution().toNanos();
            TimeUnit resolutionUnit = FileStoreAttributes.getUnit(resolution);
            long resolutionValue = resolutionUnit.convert(resolution, TimeUnit.NANOSECONDS);
            long minRacyThreshold = c.getMinimalRacyInterval().toNanos();
            TimeUnit minRacyThresholdUnit = FileStoreAttributes.getUnit(minRacyThreshold);
            long minRacyThresholdValue = minRacyThresholdUnit.convert(minRacyThreshold, TimeUnit.NANOSECONDS);
            int max_retries = 5;
            int retries = 0;
            boolean succeeded = false;
            String key = FileStoreAttributes.getConfigKey(s);
            while (!succeeded && retries < 5) {
                try {
                    userConfig.load();
                    userConfig.setString("filesystem", key, "timestampResolution", String.format("%d %s", resolutionValue, resolutionUnit.name().toLowerCase()));
                    userConfig.setString("filesystem", key, "minRacyThreshold", String.format("%d %s", minRacyThresholdValue, minRacyThresholdUnit.name().toLowerCase()));
                    userConfig.save();
                    succeeded = true;
                }
                catch (LockFailedException e) {
                    try {
                        if (++retries < 5) {
                            Thread.sleep(100L);
                            LOG.debug("locking {} failed, retries {}/{}", userConfig, retries, 5);
                            continue;
                        }
                        LOG.warn(MessageFormat.format(JGitText.get().lockFailedRetry, userConfig, retries));
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                catch (IOException e) {
                    LOG.error(MessageFormat.format(JGitText.get().cannotSaveConfig, userConfig), e);
                    break;
                }
                catch (ConfigInvalidException e) {
                    LOG.error(MessageFormat.format(JGitText.get().repositoryConfigFileInvalid, userConfig, e.getMessage()));
                    break;
                }
            }
        }

        private static String getConfigKey(FileStore s) {
            String storeKey;
            if (SystemReader.getInstance().isWindows()) {
                Object attribute = null;
                try {
                    attribute = s.getAttribute("volume:vsn");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                storeKey = attribute instanceof Integer ? attribute.toString() : s.name();
            } else {
                storeKey = s.name();
            }
            return String.valueOf(javaVersionPrefix) + storeKey;
        }

        private static TimeUnit getUnit(long nanos) {
            TimeUnit unit = nanos < 200000L ? TimeUnit.NANOSECONDS : (nanos < 200000000L ? TimeUnit.MICROSECONDS : TimeUnit.MILLISECONDS);
            return unit;
        }

        public Duration getMinimalRacyInterval() {
            return this.minimalRacyInterval;
        }

        @NonNull
        public Duration getFsTimestampResolution() {
            return this.fsTimestampResolution;
        }

        public FileStoreAttributes(@NonNull Duration fsTimestampResolution) {
            this.fsTimestampResolution = fsTimestampResolution;
            this.minimalRacyInterval = Duration.ZERO;
        }

        public String toString() {
            return String.format("FileStoreAttributes[fsTimestampResolution=%,d \u00b5s, minimalRacyInterval=%,d \u00b5s]", this.fsTimestampResolution.toNanos() / 1000L, this.minimalRacyInterval.toNanos() / 1000L);
        }
    }

    private static class GobblerThread
    extends Thread {
        private static final int PROCESS_EXIT_TIMEOUT = 5;
        private final Process p;
        private final String desc;
        private final String dir;
        final AtomicBoolean fail = new AtomicBoolean();
        final AtomicReference<String> errorMessage = new AtomicReference();
        final AtomicReference<Throwable> exception = new AtomicReference();

        GobblerThread(Process p, String[] command, File dir) {
            this.p = p;
            this.desc = Arrays.toString(command);
            this.dir = Objects.toString(dir);
        }

        @Override
        public void run() {
            StringBuilder err = new StringBuilder();
            try {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (InputStream is = this.p.getErrorStream();){
                        int ch;
                        while ((ch = is.read()) != -1) {
                            err.append((char)ch);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (this.waitForProcessCompletion(e) && this.p.exitValue() != 0) {
                        this.setError(e, e.getMessage(), this.p.exitValue());
                        this.fail.set(true);
                    }
                    if (this.waitForProcessCompletion(null) && err.length() > 0) {
                        this.setError(null, err.toString(), this.p.exitValue());
                        if (this.p.exitValue() != 0) {
                            this.fail.set(true);
                        }
                    }
                }
            }
            finally {
                if (this.waitForProcessCompletion(null) && err.length() > 0) {
                    this.setError(null, err.toString(), this.p.exitValue());
                    if (this.p.exitValue() != 0) {
                        this.fail.set(true);
                    }
                }
            }
        }

        private boolean waitForProcessCompletion(IOException originalError) {
            try {
                if (!this.p.waitFor(5L, TimeUnit.SECONDS)) {
                    this.setError(originalError, MessageFormat.format(JGitText.get().commandClosedStderrButDidntExit, this.desc, 5), -1);
                    this.fail.set(true);
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.setError(originalError, MessageFormat.format(JGitText.get().threadInterruptedWhileRunning, this.desc), -1);
                this.fail.set(true);
                return false;
            }
            return true;
        }

        private void setError(IOException e, String message, int exitCode) {
            this.exception.set(e);
            this.errorMessage.set(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCommand, this.desc, this.dir, exitCode, message));
        }
    }

    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }

    public static class LockToken
    implements Closeable {
        private boolean isCreated;
        private Optional<Path> link;

        LockToken(boolean isCreated, Optional<Path> link) {
            this.isCreated = isCreated;
            this.link = link;
        }

        public boolean isCreated() {
            return this.isCreated;
        }

        @Override
        public void close() {
            if (!this.link.isPresent()) {
                return;
            }
            Path p = this.link.get();
            if (!Files.exists(p, new LinkOption[0])) {
                return;
            }
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                LOG.error(MessageFormat.format(JGitText.get().closeLockTokenFailed, this), e);
            }
        }

        public String toString() {
            return "LockToken [lockCreated=" + this.isCreated + ", link=" + (this.link.isPresent() ? this.link.get().getFileName() + "]" : "<null>]");
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public StreamGobbler(InputStream stream, OutputStream output) {
            this.in = stream;
            this.out = output;
        }

        @Override
        public void run() {
            try {
                this.copy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void copy() throws IOException {
            int readBytes;
            boolean writeFailure = false;
            byte[] buffer = new byte[4096];
            while ((readBytes = this.in.read(buffer)) != -1) {
                if (writeFailure || this.out == null) continue;
                try {
                    this.out.write(buffer, 0, readBytes);
                    this.out.flush();
                }
                catch (IOException e) {
                    writeFailure = true;
                }
            }
        }
    }
}

