/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.atlas.graph.jackson.PluginKeyDeserializer;
import org.commonjava.maven.atlas.graph.jackson.PluginKeySerializer;
import org.commonjava.maven.atlas.graph.jackson.ProjectRelationshipDeserializer;
import org.commonjava.maven.atlas.graph.jackson.ProjectRelationshipSerializer;
import org.commonjava.maven.atlas.graph.model.PluginKey;
import org.commonjava.maven.atlas.graph.rel.BomRelationship;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.ExtensionRelationship;
import org.commonjava.maven.atlas.graph.rel.ParentRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginRelationship;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleBomRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleExtensionRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleParentRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginRelationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRelationshipSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends ProjectRelationship>> REL_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ProjectRelationship.class, BomRelationship.class, DependencyRelationship.class, ExtensionRelationship.class, ParentRelationship.class, PluginDependencyRelationship.class, PluginRelationship.class, SimpleBomRelationship.class, SimpleDependencyRelationship.class, SimpleExtensionRelationship.class, SimpleParentRelationship.class, SimplePluginDependencyRelationship.class, SimplePluginRelationship.class)));
    public static final ProjectRelationshipSerializerModule INSTANCE = new ProjectRelationshipSerializerModule();

    public ProjectRelationshipSerializerModule() {
        super("ProjectRelationship<?> Serializer");
        for (Class<? extends ProjectRelationship> cls : REL_CLASSES) {
            this.register(cls);
        }
        this.addKeySerializer(PluginKey.class, new PluginKeySerializer());
        this.addKeyDeserializer(PluginKey.class, new PluginKeyDeserializer());
    }

    private <T extends ProjectRelationship> void register(Class<T> cls) {
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        logger2.debug("Registering serializer/deserializer for: {}", (Object)cls.getSimpleName());
        this.addSerializer(cls, new ProjectRelationshipSerializer<T>(cls));
        this.addDeserializer(cls, new ProjectRelationshipDeserializer());
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode() + 17;
    }

    public boolean equals(Object other) {
        return this.getClass().equals(other.getClass());
    }
}

