/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.rel;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipConstants;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;

public abstract class AbstractSimpleProjectRelationship<R extends ProjectRelationship<R, T>, T extends ProjectVersionRef>
implements ProjectRelationship<R, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<URI> sources = new ArrayList<URI>();
    private final RelationshipType type;
    private final ProjectVersionRef declaring;
    private final T target;
    private final int index;
    private boolean managed = false;
    private boolean inherited;
    private boolean mixin;
    private transient Constructor<? extends AbstractSimpleProjectRelationship> cloneCtor;
    private URI pomLocation;
    private final boolean cloneUsesLocation = true;

    protected AbstractSimpleProjectRelationship(URI source, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean inherited, boolean mixin) {
        this(Collections.singleton(source), RelationshipConstants.POM_ROOT_URI, type, declaring, target, index, false, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(Collection<URI> sources, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean inherited, boolean mixin) {
        this(sources, RelationshipConstants.POM_ROOT_URI, type, declaring, target, index, false, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(URI source, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean managed, boolean inherited, boolean mixin) {
        this(Collections.singleton(source), RelationshipConstants.POM_ROOT_URI, type, declaring, target, index, managed, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(Collection<URI> sources, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean managed, boolean inherited, boolean mixin) {
        this(sources, RelationshipConstants.POM_ROOT_URI, type, declaring, target, index, managed, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(URI source, URI pomLocation, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean inherited, boolean mixin) {
        this(Collections.singleton(source), pomLocation, type, declaring, target, index, false, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(Collection<URI> sources, URI pomLocation, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean inherited, boolean mixin) {
        this(sources, pomLocation, type, declaring, target, index, false, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(URI source, URI pomLocation, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean managed, boolean inherited, boolean mixin) {
        this(Collections.singleton(source), pomLocation, type, declaring, target, index, managed, inherited, mixin);
    }

    protected AbstractSimpleProjectRelationship(Collection<URI> sources, URI pomLocation, RelationshipType type, ProjectVersionRef declaring, T target, int index, boolean managed, boolean inherited, boolean mixin) {
        if (sources == null) {
            throw new NullPointerException("Source URIs cannot be null");
        }
        for (URI u : sources) {
            if (this.sources.contains(u)) continue;
            this.sources.add(u);
        }
        this.pomLocation = pomLocation;
        if (declaring == null || target == null) {
            throw new NullPointerException("Neither declaring ref (" + declaring + ") nor target ref (" + target + ") can be null!");
        }
        this.type = type;
        this.declaring = declaring;
        this.target = target;
        this.index = index;
        this.managed = managed;
        this.inherited = inherited;
        this.mixin = mixin;
    }

    public AbstractSimpleProjectRelationship(ProjectRelationship<R, T> relationship) {
        this.sources.addAll(relationship.getSources());
        this.declaring = new SimpleProjectVersionRef(relationship.getDeclaring());
        this.pomLocation = relationship.getPomLocation();
        this.index = relationship.getIndex();
        this.managed = relationship.isManaged();
        this.inherited = relationship.isInherited();
        this.mixin = relationship.isMixin();
        this.type = relationship.getType();
        this.target = this.cloneTarget(relationship.getTarget());
    }

    protected abstract T cloneTarget(T var1);

    @Override
    public final boolean isManaged() {
        return this.managed;
    }

    @Override
    public final boolean isInherited() {
        return this.inherited;
    }

    @Override
    public final boolean isMixin() {
        return this.mixin;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final RelationshipType getType() {
        return this.type;
    }

    @Override
    public final ProjectVersionRef getDeclaring() {
        return this.declaring;
    }

    @Override
    public final T getTarget() {
        return this.target;
    }

    @Override
    public abstract ArtifactRef getTargetArtifact();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaring == null ? 0 : this.declaring.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectRelationship)) {
            return false;
        }
        ProjectRelationship other = (ProjectRelationship)obj;
        if (this.declaring == null ? other.getDeclaring() != null : !this.declaring.equals(other.getDeclaring())) {
            return false;
        }
        if (this.target == null ? other.getTarget() != null : !this.target.equals(other.getTarget())) {
            return false;
        }
        return this.type == other.getType();
    }

    @Override
    public final Set<URI> getSources() {
        return new HashSet<URI>(this.sources);
    }

    @Override
    public final URI getPomLocation() {
        return this.pomLocation;
    }
}

