/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.rel;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.BomRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;

public class SimpleBomRelationship
extends AbstractSimpleProjectRelationship<BomRelationship, ProjectVersionRef>
implements BomRelationship {
    private static final long serialVersionUID = 1L;

    public SimpleBomRelationship(Collection<URI> sources, ProjectVersionRef d, ProjectVersionRef t, int index, boolean inherited, boolean mixin) {
        super(sources, RelationshipType.BOM, d, t, index, false, inherited, mixin);
    }

    public SimpleBomRelationship(URI source, ProjectVersionRef d, ProjectVersionRef t, int index, boolean inherited, boolean mixin) {
        super(source, RelationshipType.BOM, d, t, index, false, inherited, mixin);
    }

    public SimpleBomRelationship(Collection<URI> sources, URI pomLocation, ProjectVersionRef d, ProjectVersionRef t, int index, boolean inherited, boolean mixin) {
        super(sources, pomLocation, RelationshipType.BOM, d, t, index, false, inherited, mixin);
    }

    public SimpleBomRelationship(URI source, URI pomLocation, ProjectVersionRef d, ProjectVersionRef t, int index, boolean inherited, boolean mixin) {
        super(source, pomLocation, RelationshipType.BOM, d, t, index, false, inherited, mixin);
    }

    public SimpleBomRelationship(BomRelationship relationship) {
        super(relationship);
    }

    @Override
    protected ProjectVersionRef cloneTarget(ProjectVersionRef target) {
        return new SimpleProjectVersionRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return this.getTarget().asPomArtifact();
    }

    @Override
    public BomRelationship selectDeclaring(ProjectVersionRef ref) {
        Object t = this.getTarget();
        return new SimpleBomRelationship((Collection<URI>)this.getSources(), ref, (ProjectVersionRef)t, this.getIndex(), this.isInherited(), this.isMixin());
    }

    @Override
    public BomRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        return new SimpleBomRelationship(this.getSources(), d, ref, this.getIndex(), this.isInherited(), this.isMixin());
    }

    @Override
    public BomRelationship cloneFor(ProjectVersionRef declaring) {
        return new SimpleBomRelationship((Collection<URI>)this.getSources(), this.getPomLocation(), declaring, (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited(), this.isMixin());
    }

    @Override
    public BomRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimpleBomRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited(), this.isMixin());
    }

    @Override
    public BomRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimpleBomRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited(), this.isMixin());
    }

    public String toString() {
        return String.format("BomRelationship [%s => %s]", this.getDeclaring(), this.getTarget());
    }
}

