/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.util;

import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;

public final class IdentityUtils {
    private IdentityUtils() {
    }

    public static ArtifactRef artifact(String groupId, String artifactId, String version) throws InvalidVersionSpecificationException {
        return new SimpleArtifactRef(IdentityUtils.projectVersion(groupId, artifactId, version), null, null);
    }

    public static ArtifactRef artifact(ProjectVersionRef ref) throws InvalidVersionSpecificationException {
        return new SimpleArtifactRef(ref, null, null);
    }

    public static ArtifactRef artifact(String groupId, String artifactId, String version, String type, String classifier) throws InvalidVersionSpecificationException {
        return new SimpleArtifactRef(IdentityUtils.projectVersion(groupId, artifactId, version), type, classifier);
    }

    public static ArtifactRef artifact(ProjectVersionRef dep, String type, String classifier) {
        return new SimpleArtifactRef(dep, type, classifier);
    }

    public static ProjectVersionRef projectVersion(String src) {
        String[] parts = src.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Must contain exactly three fields separated by ':'");
        }
        try {
            return new SimpleProjectVersionRef(parts[0], parts[1], parts[2]);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Version: '" + parts[2] + "' is invalid: " + e.getMessage(), e);
        }
    }

    public static ProjectVersionRef projectVersion(String groupId, String artifactId, String version) throws InvalidVersionSpecificationException {
        return new SimpleProjectVersionRef(groupId, artifactId, version);
    }

    public static ProjectRef project(String src) {
        String[] parts = src.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid: '" + src + "'. Must contain at least two fields separated by ':'");
        }
        return new SimpleProjectRef(parts[0], parts[1]);
    }

    public static ProjectRef project(String groupId, String artifactId) throws InvalidVersionSpecificationException {
        return new SimpleProjectRef(groupId, artifactId);
    }
}

