/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Properties;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.io.rest.DefaultTranslator;
import org.commonjava.maven.ext.io.rest.Translator;

public class RESTState
implements State {
    private final String restURL;
    private final Translator restEndpoint;

    public RESTState(ManipulationSession session) throws ManipulationException {
        VersioningState vState = session.getState(VersioningState.class);
        Properties userProps = session.getUserProperties();
        this.restURL = userProps.getProperty("restURL");
        String repositoryGroup = userProps.getProperty("restRepositoryGroup", "");
        int restMaxSize = Integer.valueOf(userProps.getProperty("restMaxSize", "-1"));
        int restMinSize = Integer.valueOf(userProps.getProperty("restMinSize", String.valueOf(4)));
        Translator.RestProtocol protocol = Translator.RestProtocol.parse(userProps.getProperty("restProtocol", Translator.RestProtocol.CURRENT.toString()));
        this.restEndpoint = new DefaultTranslator(this.restURL, protocol, restMaxSize, restMinSize, repositoryGroup, vState.getIncrementalSerialSuffix());
    }

    @Override
    public boolean isEnabled() {
        return this.restURL != null && !this.restURL.isEmpty();
    }

    public Translator getVersionTranslator() {
        return this.restEndpoint;
    }
}

