/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.model.GAV;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyFlag;

public class VersioningState
implements State {
    public static final PropertyFlag VERSION_SUFFIX_SYSPROP = new PropertyFlag("version.suffix", "versionSuffix");
    public static final PropertyFlag INCREMENT_SERIAL_SUFFIX_SYSPROP = new PropertyFlag("version.incremental.suffix", "versionIncrementalSuffix");
    public static final PropertyFlag INCREMENT_SERIAL_SUFFIX_PADDING_SYSPROP = new PropertyFlag("version.incremental.suffix.padding", "versionIncrementalSuffixPadding");
    public static final PropertyFlag VERSION_SUFFIX_SNAPSHOT_SYSPROP = new PropertyFlag("version.suffix.snapshot", "versionSuffixSnapshot");
    public static final PropertyFlag VERSION_OSGI_SYSPROP = new PropertyFlag("version.osgi", "versionOsgi");
    public static final PropertyFlag VERSION_OVERRIDE_SYSPROP = new PropertyFlag("version.override", "versionOverride");
    public static final String VERSION_SUFFIX_ALT = "versionSuffixAlternatives";
    private final String suffix;
    private final String incrementalSerialSuffix;
    private final boolean preserveSnapshot;
    private final boolean osgi;
    private final String override;
    private final int incrementalSerialSuffixPadding;
    private final List<String> suffixAlternatives;
    private final List<String> allSuffixes;
    @JsonProperty
    private GAV executionRootModified;
    private final Map<ProjectVersionRef, String> versionsByGAV = new HashMap<ProjectVersionRef, String>();
    private Map<ProjectRef, Set<String>> restMetaData;

    public VersioningState(Properties userProps) {
        this.suffix = PropertiesUtils.handleDeprecatedProperty(userProps, VERSION_SUFFIX_SYSPROP);
        this.incrementalSerialSuffix = PropertiesUtils.handleDeprecatedProperty(userProps, INCREMENT_SERIAL_SUFFIX_SYSPROP);
        this.incrementalSerialSuffixPadding = Integer.parseInt(PropertiesUtils.handleDeprecatedProperty(userProps, INCREMENT_SERIAL_SUFFIX_PADDING_SYSPROP, "0"));
        this.preserveSnapshot = Boolean.parseBoolean(PropertiesUtils.handleDeprecatedProperty(userProps, VERSION_SUFFIX_SNAPSHOT_SYSPROP));
        this.osgi = Boolean.parseBoolean(PropertiesUtils.handleDeprecatedProperty(userProps, VERSION_OSGI_SYSPROP, "true"));
        this.override = PropertiesUtils.handleDeprecatedProperty(userProps, VERSION_OVERRIDE_SYSPROP);
        this.suffixAlternatives = Arrays.asList(StringUtils.split(userProps.getProperty(VERSION_SUFFIX_ALT, "redhat".equals(this.getRebuildSuffix()) ? "" : "redhat"), ","));
        this.allSuffixes = new ArrayList<String>();
        if (StringUtils.isNotEmpty(this.getRebuildSuffix())) {
            this.allSuffixes.add(this.getRebuildSuffix());
            this.allSuffixes.addAll(this.getSuffixAlternatives());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.incrementalSerialSuffix != null || this.suffix != null || this.override != null;
    }

    public void setRESTMetadata(Map<ProjectRef, Set<String>> versionStates) {
        this.restMetaData = versionStates;
    }

    public Map<ProjectRef, Set<String>> getRESTMetadata() {
        return this.restMetaData;
    }

    public void setVersionsByGAVMap(Map<ProjectVersionRef, String> versionsByGAV) {
        this.versionsByGAV.putAll(versionsByGAV);
    }

    public void setExecutionRootModified(GAV executionRootModified) {
        this.executionRootModified = executionRootModified;
    }

    public boolean hasVersionsByGAV() {
        return !this.versionsByGAV.isEmpty();
    }

    public String getRebuildSuffix() {
        String suffix = "";
        if (!StringUtils.isEmpty(this.getSuffix())) {
            int dashIndex = this.getSuffix().lastIndexOf(45);
            suffix = this.getSuffix().substring(0, dashIndex > 0 ? dashIndex : this.getSuffix().length());
        } else if (!StringUtils.isEmpty(this.getIncrementalSerialSuffix())) {
            suffix = this.getIncrementalSerialSuffix();
        }
        return suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getIncrementalSerialSuffix() {
        return this.incrementalSerialSuffix;
    }

    public boolean isPreserveSnapshot() {
        return this.preserveSnapshot;
    }

    public boolean isOsgi() {
        return this.osgi;
    }

    public String getOverride() {
        return this.override;
    }

    public int getIncrementalSerialSuffixPadding() {
        return this.incrementalSerialSuffixPadding;
    }

    public List<String> getSuffixAlternatives() {
        return this.suffixAlternatives;
    }

    public List<String> getAllSuffixes() {
        return this.allSuffixes;
    }

    public GAV getExecutionRootModified() {
        return this.executionRootModified;
    }

    public Map<ProjectVersionRef, String> getVersionsByGAV() {
        return this.versionsByGAV;
    }
}

