/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.commonjava.util.jhttpc.model.SiteConfig;
import org.commonjava.util.jhttpc.model.SiteTrustType;

public class SiteConfigBuilder {
    public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final int DEFAULT_MAX_CONNECTIONS = 4;
    private String id;
    private String uri;
    private String user;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private SiteTrustType trustType;
    private String keyCertPem;
    private String serverCertPem;
    private Map<String, Object> attributes;
    private Integer requestTimeoutSeconds;
    private Integer maxConnections;

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public SiteConfigBuilder() {
    }

    public SiteConfigBuilder(String id, String uri) {
        this.id = id;
        this.uri = uri;
    }

    public SiteConfig build() {
        return new SiteConfig(this.id, this.uri, this.user, this.proxyHost, this.proxyPort, this.proxyUser, this.trustType, this.keyCertPem, this.serverCertPem, this.requestTimeoutSeconds, this.maxConnections, this.attributes);
    }

    public String getId() {
        return this.id;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort == null ? 8080 : this.proxyPort;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() throws MalformedURLException {
        return new URL(this.getUri()).getHost();
    }

    public int getPort() throws MalformedURLException {
        URL u = new URL(this.getUri());
        int port = u.getPort();
        if (port < 1) {
            port = u.getDefaultPort();
        }
        return port;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getKeyCertPem() {
        return this.keyCertPem;
    }

    public String getUri() {
        return this.uri;
    }

    public String getServerCertPem() {
        return this.serverCertPem;
    }

    public int getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds == null ? 10 : this.requestTimeoutSeconds;
    }

    public synchronized Object setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public SiteConfigBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public SiteConfigBuilder withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public SiteConfigBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public SiteConfigBuilder withProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public SiteConfigBuilder withProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public SiteConfigBuilder withProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public SiteConfigBuilder withTrustType(SiteTrustType trustType) {
        this.trustType = trustType;
        return this;
    }

    public SiteConfigBuilder withKeyCertPem(String keyCertPem) {
        this.keyCertPem = keyCertPem;
        return this;
    }

    public SiteConfigBuilder withServerCertPem(String serverCertPem) {
        this.serverCertPem = serverCertPem;
        return this;
    }

    public SiteConfigBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SiteConfigBuilder withRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections == null ? 4 : this.maxConnections;
    }

    public SiteConfigBuilder withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public SiteTrustType getTrustType() {
        return this.trustType == null ? SiteTrustType.DEFAULT : this.trustType;
    }

    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiteConfigBuilder)) {
            return false;
        }
        SiteConfigBuilder that = (SiteConfigBuilder)o;
        return !(this.getId() == null ? that.getId() != null : !this.getId().equals(that.getId()));
    }

    public int hashCode() {
        return 13 + (this.getId() != null ? this.getId().hashCode() : 0);
    }

    public String toString() {
        return "SiteConfig{id='" + this.id + '\'' + '}';
    }
}

