/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class CdiConstructorInjector
implements ConstructorInjector {
    private BeanManager manager;
    private Type type;

    public CdiConstructorInjector(Type type, BeanManager manager) {
        this.type = type;
        this.manager = manager;
    }

    @Override
    public Object construct(boolean unwrapAsync) {
        Set<Bean<?>> beans = this.manager.getBeans(this.type, new Annotation[0]);
        if (beans.size() > 1) {
            HashSet modifiableBeans = new HashSet();
            modifiableBeans.addAll(beans);
            Iterator iterator = modifiableBeans.iterator();
            while (iterator.hasNext()) {
                Bean bean = (Bean)iterator.next();
                if (bean.getBeanClass().equals(this.type) || bean.isAlternative()) continue;
                iterator.remove();
            }
            beans = modifiableBeans;
        }
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.beansFound(this.type, beans));
        }
        Bean bean = this.manager.resolve(beans);
        CreationalContext context = this.manager.createCreationalContext(bean);
        return this.manager.getReference(bean, this.type, context);
    }

    @Override
    public Object construct(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        return this.construct(unwrapAsync);
    }

    @Override
    public Object injectableArguments(boolean unwrapAsync) {
        return null;
    }

    @Override
    public Object injectableArguments(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure {
        return this.injectableArguments(unwrapAsync);
    }
}

