/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedInputBuffer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.FinalizedClientResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class ApacheHttpAsyncClient4Engine
implements AsyncClientHttpEngine,
Closeable {
    protected final CloseableHttpAsyncClient client;
    protected final boolean closeHttpClient;

    public ApacheHttpAsyncClient4Engine(CloseableHttpAsyncClient client, boolean closeHttpClient) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        this.client = client;
        this.closeHttpClient = closeHttpClient;
        if (closeHttpClient && !client.isRunning()) {
            client.start();
        }
    }

    @Override
    public void close() {
        if (this.closeHttpClient) {
            IOUtils.closeQuietly((Closeable)this.client);
        }
    }

    @Override
    public SSLContext getSslContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response invoke(Invocation request) {
        Future<ClientResponse> future = this.submit((ClientInvocation)request, false, null, new AsyncClientHttpEngine.ResultExtractor<ClientResponse>(){

            @Override
            public ClientResponse extractResult(ClientResponse response) {
                return response;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw ApacheHttpAsyncClient4Engine.clientException(e, null);
        }
        catch (ExecutionException e) {
            throw ApacheHttpAsyncClient4Engine.clientException(e.getCause(), null);
        }
    }

    @Override
    public <T> Future<T> submit(ClientInvocation request, boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        HttpUriRequest httpRequest = ApacheHttpAsyncClient4Engine.buildHttpRequest(request);
        if (buffered) {
            HttpAsyncRequestProducer requestProducer = HttpAsyncMethods.create(httpRequest);
            BufferingResponseConsumer<T> responseConsumer = new BufferingResponseConsumer<T>(request, extractor);
            CallbackAdapter<T> httpCallback = callback != null ? new CallbackAdapter<T>(callback) : null;
            return this.client.execute(requestProducer, responseConsumer, httpCallback);
        }
        if (callback != null) {
            throw new IllegalArgumentException("unbuffered InvocationCallback is not supported");
        }
        HttpAsyncRequestProducer requestProducer = HttpAsyncMethods.create(httpRequest);
        StreamingResponseConsumer<T> responseConsumer = new StreamingResponseConsumer<T>(request, extractor);
        Future<T> httpFuture = this.client.execute(requestProducer, responseConsumer, null);
        return responseConsumer.future(httpFuture);
    }

    @Override
    public <T> CompletableFuture<T> submit(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<T> extractor, ExecutorService executorService) {
        if (buffered) {
            final CompletableFuture cf = new CompletableFuture();
            InvocationCallback callback = new InvocationCallback<T>(){

                @Override
                public void completed(T response) {
                    cf.complete(response);
                }

                @Override
                public void failed(Throwable throwable) {
                    cf.completeExceptionally(throwable);
                }
            };
            this.submit(request, buffered, callback, extractor);
            return cf;
        }
        Supplier<Object> supplier = () -> {
            try {
                return this.submit(request, buffered, null, extractor).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
        if (executorService == null) {
            return CompletableFuture.supplyAsync(supplier);
        }
        return CompletableFuture.supplyAsync(supplier, executorService);
    }

    private static HttpUriRequest buildHttpRequest(ClientInvocation request) {
        HttpRequestBase httpRequest = ApacheHttpAsyncClient4Engine.createHttpMethod(request.getUri(), request.getMethod());
        if (request.getEntity() != null) {
            byte[] requestContent = ApacheHttpAsyncClient4Engine.requestContent(request);
            ByteArrayEntity entity = new ByteArrayEntity(requestContent);
            entity.setContentType(new BasicHeader("Content-Type", request.getHeaders().getMediaType().toString()));
            ApacheHttpAsyncClient4Engine.commitHeaders(request, httpRequest);
            ((HttpEntityEnclosingRequest)((Object)httpRequest)).setEntity(entity);
        } else {
            ApacheHttpAsyncClient4Engine.commitHeaders(request, httpRequest);
        }
        return httpRequest;
    }

    private static byte[] requestContent(ClientInvocation request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.getDelegatingOutputStream().setDelegate(baos);
        try {
            request.writeRequestBody(request.getEntityStream());
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpRequestBase createHttpMethod(URI url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            @Override
            public String getMethod() {
                return verb;
            }
        };
    }

    private static void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    private static void copyResponse(HttpResponse httpResponse, ClientResponse clientResponse) {
        clientResponse.setStatus(httpResponse.getStatusLine().getStatusCode());
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        clientResponse.setHeaders(headers);
    }

    private static RuntimeException clientException(Throwable ex, Response clientResponse) {
        RuntimeException ret = ex == null ? new ProcessingException(new NullPointerException()) : (ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex))));
        return ret;
    }

    private static IOException ioException(Exception ex) {
        return ex instanceof IOException ? (IOException)ex : new IOException(ex);
    }

    private static class EndOfStream
    implements ContentDecoder {
        public static EndOfStream INSTANCE = new EndOfStream();

        private EndOfStream() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return -1;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }
    }

    private static class ConnectionResponse
    extends FinalizedClientResponse {
        private InputStream connection;
        private InputStream stream;

        ConnectionResponse(ClientConfiguration configuration, Map<String, Object> properties) {
            super(configuration, RESTEasyTracingLogger.empty());
            this.setProperties(properties);
        }

        public synchronized void setConnection(InputStream connection) {
            this.connection = connection;
            this.stream = connection;
        }

        @Override
        protected synchronized void setInputStream(InputStream is) {
            this.stream = is;
            this.resetEntity();
        }

        @Override
        public synchronized InputStream getInputStream() {
            return this.stream;
        }

        @Override
        public synchronized void releaseConnection() throws IOException {
            this.releaseConnection(false);
        }

        @Override
        public synchronized void releaseConnection(boolean consumeInputStream) throws IOException {
            boolean thrown = true;
            try {
                if (this.stream != null) {
                    if (consumeInputStream) {
                        while (this.stream.read() > 0) {
                        }
                    }
                    this.stream.close();
                }
                thrown = false;
            }
            finally {
                if (this.connection != null) {
                    if (thrown) {
                        IOUtils.closeQuietly(this.connection);
                    } else {
                        this.connection.close();
                    }
                }
            }
        }
    }

    private static class CallbackAdapter<T>
    implements FutureCallback<T> {
        private final InvocationCallback<T> invocationCallback;

        CallbackAdapter(InvocationCallback<T> invocationCallback) {
            this.invocationCallback = invocationCallback;
        }

        @Override
        public void cancelled() {
            this.invocationCallback.failed(new ProcessingException("cancelled"));
        }

        @Override
        public void completed(T response) {
            try {
                this.invocationCallback.completed(response);
            }
            catch (Throwable t) {
                LogMessages.LOGGER.exceptionIgnored(t);
            }
            finally {
                if (response instanceof Response) {
                    ((Response)response).close();
                }
            }
        }

        @Override
        public void failed(Exception ex) {
            this.invocationCallback.failed(ApacheHttpAsyncClient4Engine.clientException(ex, null));
        }
    }

    private static class BufferingResponseConsumer<T>
    extends AbstractAsyncResponseConsumer<T> {
        private ClientConfiguration configuration;
        private Map<String, Object> properties;
        private AsyncClientHttpEngine.ResultExtractor<T> responseExtractor;
        private ConnectionResponse clientResponse;
        private SimpleInputBuffer buf;

        BufferingResponseConsumer(ClientInvocation request, AsyncClientHttpEngine.ResultExtractor<T> responseExtractor) {
            this.configuration = request.getClientConfiguration();
            this.properties = request.getMutableProperties();
            this.responseExtractor = responseExtractor;
        }

        @Override
        protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
            ConnectionResponse clientResponse = new ConnectionResponse(this.configuration, this.properties);
            ApacheHttpAsyncClient4Engine.copyResponse(response, clientResponse);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                long len = entity.getContentLength();
                if (len > Integer.MAX_VALUE) {
                    throw new ContentTooLongException("Entity content is too long: " + len);
                }
                if (len < 0L) {
                    len = 4096L;
                }
                this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
            }
            this.clientResponse = clientResponse;
        }

        @Override
        protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        }

        @Override
        protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            SimpleInputBuffer buf = this.buf;
            if (buf == null) {
                throw new NullPointerException("Content Buffer");
            }
            buf.consumeContent(decoder);
        }

        @Override
        protected T buildResult(HttpContext context) throws Exception {
            if (this.buf != null) {
                this.clientResponse.setConnection(new ContentInputStream(this.buf));
            }
            return this.responseExtractor.extractResult(this.clientResponse);
        }

        @Override
        protected void releaseResources() {
            this.configuration = null;
            this.properties = null;
            this.responseExtractor = null;
            this.clientResponse = null;
            this.buf = null;
        }
    }

    private static class StreamingResponseConsumer<T>
    implements HttpAsyncResponseConsumer<T> {
        private static final IOException unallowedBlockingReadException = new IOException("blocking reads inside an async io-handler are not allowed"){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        private ClientConfiguration configuration;
        private Map<String, Object> properties;
        private AsyncClientHttpEngine.ResultExtractor<T> extractor;
        private ResultFuture<T> future;
        private SharedInputStream sharedStream;
        private volatile boolean hasResult;
        private volatile T result;
        private volatile Exception exception;
        private volatile boolean completed;

        StreamingResponseConsumer(ClientInvocation request, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
            this.configuration = request.getClientConfiguration();
            this.properties = request.getMutableProperties();
            this.extractor = extractor;
        }

        private void releaseResources() {
            this.configuration = null;
            this.properties = null;
            this.extractor = null;
            this.future = null;
            this.sharedStream = null;
        }

        public synchronized Future<T> future(Future<T> httpFuture) {
            if (this.completed) {
                return httpFuture;
            }
            this.future = new ResultFuture<T>(httpFuture);
            this.future.copyHttpFutureResult();
            if (!this.future.isDone() && this.hasResult) {
                this.future.completed(this.getResult());
            }
            return this.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
            SharedInputStream sharedStream = null;
            ConnectionResponse clientResponse = null;
            Object result = null;
            RuntimeException exception = null;
            boolean success = false;
            try {
                clientResponse = new ConnectionResponse(this.configuration, this.properties);
                ApacheHttpAsyncClient4Engine.copyResponse(httpResponse, clientResponse);
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    sharedStream = new SharedInputStream(new SharedInputBuffer(16384));
                    clientResponse.setConnection(sharedStream);
                    sharedStream.setException(unallowedBlockingReadException);
                    result = this.extractor.extractResult(clientResponse);
                    sharedStream.setException(null);
                } else {
                    result = this.extractor.extractResult(clientResponse);
                }
                success = true;
            }
            catch (Exception e) {
                exception = ApacheHttpAsyncClient4Engine.clientException(e, clientResponse);
            }
            finally {
                if (success) {
                    this.sharedStream = sharedStream;
                    this.result = result;
                    this.hasResult = true;
                    if (this.future != null) {
                        this.future.completed(result);
                    }
                } else {
                    this.exception = exception;
                    this.completed = true;
                    if (this.future != null) {
                        this.future.failed(exception);
                    }
                    this.releaseResources();
                }
            }
        }

        @Override
        public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            if (this.sharedStream != null) {
                this.sharedStream.consumeContent(decoder, ioctrl);
            }
        }

        @Override
        public synchronized void responseCompleted(HttpContext context) {
            this.completed = true;
            try {
                if (this.sharedStream != null) {
                    this.sharedStream.consumeContent(EndOfStream.INSTANCE, null);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                this.releaseResources();
            }
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public T getResult() {
            return this.result;
        }

        @Override
        public boolean isDone() {
            return this.completed;
        }

        @Override
        public synchronized void close() {
            this.completed = true;
            ResultFuture<T> future = this.future;
            if (future != null) {
                future.copyHttpFutureResult();
                if (!future.isDone()) {
                    future.failed(ApacheHttpAsyncClient4Engine.clientException(new IOException("connect failed"), null));
                }
            }
            this.releaseResources();
        }

        @Override
        public synchronized void failed(Exception ex) {
            this.completed = true;
            if (this.future != null) {
                this.future.failed(ApacheHttpAsyncClient4Engine.clientException(ex, null));
            }
            if (this.sharedStream != null) {
                this.sharedStream.setException(ApacheHttpAsyncClient4Engine.ioException(ex));
                IOUtils.closeQuietly(this.sharedStream);
            }
            this.releaseResources();
        }

        @Override
        public synchronized boolean cancel() {
            this.completed = true;
            if (this.future != null) {
                this.future.cancelledResult();
            }
            if (this.sharedStream != null) {
                this.sharedStream.setException(new IOException("cancelled"));
                IOUtils.closeQuietly(this.sharedStream);
            }
            this.releaseResources();
            return true;
        }

        private class SharedInputStream
        extends ContentInputStream {
            private final SharedInputBuffer sharedBuf;
            private volatile IOException ex;
            private volatile IOControl ioctrl;

            SharedInputStream(SharedInputBuffer sharedBuf) {
                super(sharedBuf);
                this.sharedBuf = sharedBuf;
            }

            public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
                if (ioctrl != null) {
                    this.ioctrl = ioctrl;
                }
                this.sharedBuf.consumeContent(decoder, ioctrl);
            }

            @Override
            public void close() throws IOException {
                StreamingResponseConsumer.this.completed = true;
                this.sharedBuf.close();
                IOControl ioctrl = this.ioctrl;
                if (ioctrl != null) {
                    ioctrl.requestInput();
                }
                super.close();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.throwIfError();
                return super.read(b, off, len);
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.throwIfError();
                return super.read(b, 0, b.length);
            }

            @Override
            public int read() throws IOException {
                this.throwIfError();
                return super.read();
            }

            private void throwIfError() throws IOException {
                IOException ex = this.ex;
                if (ex != null) {
                    throw new IOException(ex);
                }
            }

            public void setException(IOException e) {
                this.ex = e;
            }
        }

        private static class ResultFuture<T>
        extends BasicFuture<T> {
            private final Future<T> httpFuture;

            ResultFuture(Future<T> httpFuture) {
                super(null);
                this.httpFuture = httpFuture;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                this.httpFuture.cancel(mayInterruptIfRunning);
                return cancelled;
            }

            public void cancelledResult() {
                super.cancel(true);
            }

            public void copyHttpFutureResult() {
                if (!this.isDone() && this.httpFuture.isDone()) {
                    try {
                        this.completed(this.httpFuture.get());
                    }
                    catch (ExecutionException e) {
                        this.failed(ApacheHttpAsyncClient4Engine.clientException(e.getCause(), null));
                    }
                    catch (InterruptedException e) {
                        this.failed(e);
                    }
                }
            }
        }
    }
}

