/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.net.URI;
import java.util.Locale;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.AsynchronousInvoke;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.CompletionStageRxInvokerImpl;

public class ClientInvocationBuilder
implements Invocation.Builder {
    protected ClientInvocation invocation;
    private final URI uri;
    private WebTarget target;

    public ClientInvocationBuilder(ResteasyClient client, URI uri, ClientConfiguration configuration) {
        this.invocation = this.createClientInvocation(client, uri, new ClientRequestHeaders(configuration), configuration);
        this.uri = uri;
    }

    protected ClientInvocation createClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        return new ClientInvocation(client, uri, headers, parent);
    }

    protected ClientInvocation createClientInvocation(ClientInvocation invocation) {
        return new ClientInvocation(invocation);
    }

    public ClientRequestHeaders getHeaders() {
        return this.invocation.headers;
    }

    public void setClientInvocation(ClientInvocation invocation) {
        this.invocation = invocation;
    }

    public ClientInvocation getClientInvocation() {
        return this.invocation;
    }

    @Override
    public Invocation.Builder accept(String ... mediaTypes) {
        this.getHeaders().accept(mediaTypes);
        return this;
    }

    @Override
    public Invocation.Builder accept(MediaType ... mediaTypes) {
        this.getHeaders().accept(mediaTypes);
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(String ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    @Override
    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.getHeaders().acceptEncoding(encodings);
        return this;
    }

    @Override
    public Invocation.Builder cookie(Cookie cookie) {
        if (!Cookie.class.equals(cookie.getClass())) {
            cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
        }
        this.getHeaders().cookie(cookie);
        return this;
    }

    @Override
    public Invocation.Builder cookie(String name, String value) {
        this.getHeaders().cookie(new Cookie(name, value));
        return this;
    }

    @Override
    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.getHeaders().cacheControl(cacheControl);
        return this;
    }

    @Override
    public Invocation.Builder header(String name, Object value) {
        this.getHeaders().header(name, value);
        return this;
    }

    @Override
    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.getHeaders().setHeaders(headers);
        return this;
    }

    @Override
    public Invocation build(String method) {
        return this.build(method, null);
    }

    @Override
    public Invocation build(String method, Entity<?> entity) {
        this.invocation.setMethod(method);
        this.invocation.setEntity(entity);
        return this.createClientInvocation(this.invocation);
    }

    @Override
    public Invocation buildGet() {
        return this.build("GET");
    }

    @Override
    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    @Override
    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    @Override
    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    @Override
    public AsyncInvoker async() {
        return new AsynchronousInvoke(this.createClientInvocation(this.invocation));
    }

    @Override
    public Response get() {
        return this.buildGet().invoke();
    }

    @Override
    public <T> T get(Class<T> responseType) {
        return this.buildGet().invoke(responseType);
    }

    @Override
    public <T> T get(GenericType<T> responseType) {
        return this.buildGet().invoke(responseType);
    }

    @Override
    public Response put(Entity<?> entity) {
        return this.buildPut(entity).invoke();
    }

    @Override
    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.buildPut(entity).invoke(responseType);
    }

    @Override
    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.buildPut(entity).invoke(responseType);
    }

    @Override
    public Response post(Entity<?> entity) {
        return this.buildPost(entity).invoke();
    }

    @Override
    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.buildPost(entity).invoke(responseType);
    }

    @Override
    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.buildPost(entity).invoke(responseType);
    }

    @Override
    public Response delete() {
        return this.buildDelete().invoke();
    }

    @Override
    public <T> T delete(Class<T> responseType) {
        return this.buildDelete().invoke(responseType);
    }

    @Override
    public <T> T delete(GenericType<T> responseType) {
        return this.buildDelete().invoke(responseType);
    }

    @Override
    public Response head() {
        return this.build("HEAD").invoke();
    }

    @Override
    public Response options() {
        return this.build("OPTIONS").invoke();
    }

    @Override
    public <T> T options(Class<T> responseType) {
        return this.build("OPTIONS").invoke(responseType);
    }

    @Override
    public <T> T options(GenericType<T> responseType) {
        return this.build("OPTIONS").invoke(responseType);
    }

    @Override
    public Response trace() {
        return this.build("TRACE").invoke();
    }

    @Override
    public <T> T trace(Class<T> responseType) {
        return this.build("TRACE").invoke(responseType);
    }

    @Override
    public <T> T trace(GenericType<T> responseType) {
        return this.build("TRACE").invoke(responseType);
    }

    @Override
    public Response method(String name) {
        return this.build(name).invoke();
    }

    @Override
    public <T> T method(String name, Class<T> responseType) {
        return this.build(name).invoke(responseType);
    }

    @Override
    public <T> T method(String name, GenericType<T> responseType) {
        return this.build(name).invoke(responseType);
    }

    @Override
    public Response method(String name, Entity<?> entity) {
        return this.build(name, entity).invoke();
    }

    @Override
    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return this.build(name, entity).invoke(responseType);
    }

    @Override
    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.build(name, entity).invoke(responseType);
    }

    @Override
    public Invocation.Builder property(String name, Object value) {
        this.invocation.property(name, value);
        return this;
    }

    public boolean isChunked() {
        return this.invocation.isChunked();
    }

    public void setChunked(boolean chunked) {
        this.invocation.setChunked(chunked);
    }

    @Override
    public CompletionStageRxInvoker rx() {
        return new CompletionStageRxInvokerImpl(this, this.invocation.getClient().asyncInvocationExecutor());
    }

    @Override
    public <T extends RxInvoker> T rx(Class<T> clazz) {
        RxInvokerProvider<T> provider = this.invocation.getClientConfiguration().getRxInvokerProvider(clazz);
        if (provider == null) {
            throw new IllegalStateException(Messages.MESSAGES.unableToInstantiate(clazz));
        }
        return provider.getRxInvoker(this, this.invocation.getClient().asyncInvocationExecutor());
    }

    public Response patch(Entity<?> entity) {
        return this.build("PATCH", entity).invoke();
    }

    public <T> T patch(Entity<?> entity, Class<T> responseType) {
        return this.build("PATCH", entity).invoke(responseType);
    }

    public <T> T patch(Entity<?> entity, GenericType<T> responseType) {
        return this.build("PATCH", entity).invoke(responseType);
    }

    public URI getURI() {
        return this.uri;
    }

    public WebTarget getTarget() {
        return this.target;
    }

    public void setTarget(WebTarget target) {
        this.target = target;
    }
}

