/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class BaseServletConfigSource {
    protected ConfigSource source;
    protected final boolean available;
    private final String name;

    public BaseServletConfigSource(boolean available, Class<?> sourceClass) {
        this.available = available;
        if (available) {
            try {
                this.source = (ConfigSource)sourceClass.newInstance();
                this.name = this.source.getName();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            this.name = this.toString();
        }
    }

    public Map<String, String> getProperties() {
        if (!this.available) {
            return Collections.emptyMap();
        }
        return this.source.getProperties();
    }

    public String getValue(String propertyName) {
        if (!this.available) {
            return null;
        }
        return this.source.getValue(propertyName);
    }

    public String getName() {
        return this.name;
    }
}

