/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.FileRange;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;

@Provider
public class FileRangeWriter
implements AsyncMessageBodyWriter<FileRange> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(FileRange.class) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    @Override
    public long getSize(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        long fileSize = fileRange.getFile().length();
        String contentRange = "bytes " + fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle("Content-Range", contentRange);
        httpHeaders.putSingle("Content-Length", length);
        try (FileInputStream fis = new FileInputStream(fileRange.getFile());){
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            while (length > 0L) {
                int len = 2048L > length ? (int)length : 2048;
                int read = fis.read(buf, 0, len);
                if (read == -1) {
                    break;
                }
                entityStream.write(buf, 0, read);
                length -= (long)len;
            }
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        long fileSize = fileRange.getFile().length();
        String contentRange = "bytes " + fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle("Content-Range", contentRange);
        httpHeaders.putSingle("Content-Length", length);
        try {
            FileInputStream fis = new FileInputStream(fileRange.getFile());
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            return this.writeTo(fis, length, entityStream, buf).whenComplete((v, t) -> {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
    }

    private CompletionStage<Void> writeTo(FileInputStream fis, long length, AsyncOutputStream entityStream, byte[] buf) {
        if (length > 0L) {
            int len = (long)buf.length > length ? (int)length : buf.length;
            try {
                int read = fis.read(buf, 0, len);
                if (read != -1) {
                    return entityStream.asyncWrite(buf, 0, read).thenCompose(v -> this.writeTo(fis, length - (long)len, entityStream, buf));
                }
            }
            catch (IOException e) {
                return ProviderHelper.completedException(e);
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

