/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Experimental(value="Loads additional config locations")
public abstract class AbstractLocationConfigSourceFactory
extends AbstractLocationConfigSourceLoader
implements ConfigSourceFactory {
    public static final String SMALLRYE_LOCATIONS = "smallrye.config.locations";

    @Override
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        ConfigValue value = context.getValue(SMALLRYE_LOCATIONS);
        if (value.getValue() == null) {
            return Collections.emptyList();
        }
        return this.loadConfigSources(Converters.newArrayConverter(Converters.STRING_CONVERTER, String[].class).convert(value.getValue()));
    }
}

