/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.SecuritySupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@Experimental(value="Loads sources by location")
public abstract class AbstractLocationConfigSourceLoader {
    private static final Converter<URI> URI_CONVERTER = new URIConverter();

    protected abstract String[] getFileExtensions();

    protected abstract ConfigSource loadConfigSource(URL var1, int var2) throws IOException;

    protected ConfigSource loadConfigSource(URL url) throws IOException {
        return this.loadConfigSource(url, 100);
    }

    protected List<ConfigSource> loadConfigSources(String location) {
        return this.loadConfigSources(new String[]{location});
    }

    protected List<ConfigSource> loadConfigSources(String location, ClassLoader classLoader) {
        return this.loadConfigSources(new String[]{location}, classLoader);
    }

    protected List<ConfigSource> loadConfigSources(String[] locations) {
        return this.loadConfigSources(locations, SecuritySupport.getContextClassLoader());
    }

    protected List<ConfigSource> loadConfigSources(String[] locations, ClassLoader classLoader) {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        for (String location : locations) {
            URI uri = URI_CONVERTER.convert(location);
            if (uri.getScheme() == null) {
                configSources.addAll(this.tryFileSystem(uri));
                configSources.addAll(this.tryClassPath(uri, classLoader));
                continue;
            }
            if (uri.getScheme().equals("file")) {
                configSources.addAll(this.tryFileSystem(uri));
                continue;
            }
            if (uri.getScheme().equals("jar")) {
                configSources.addAll(this.tryJar(uri));
                continue;
            }
            if (uri.getScheme().startsWith("http")) {
                configSources.addAll(this.tryHttpResource(uri));
                continue;
            }
            throw ConfigMessages.msg.schemeNotSupported(uri.getScheme());
        }
        return configSources;
    }

    protected List<ConfigSource> tryFileSystem(URI uri) {
        Path urlPath;
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        Path path = urlPath = uri.getScheme() != null ? Paths.get(uri) : Paths.get(uri.getPath(), new String[0]);
        if (Files.isRegularFile(urlPath, new LinkOption[0])) {
            ClassPathUtils.consumeAsPath(AbstractLocationConfigSourceLoader.toURL(urlPath.toUri()), new ConfigSourcePathConsumer(configSources));
        } else if (Files.isDirectory(urlPath, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(urlPath, this::validExtension);){
                for (Path path2 : paths) {
                    this.addConfigSource(path2.toUri(), configSources);
                }
            }
            catch (IOException e) {
                throw ConfigMessages.msg.failedToLoadResource(e);
            }
        }
        return configSources;
    }

    protected List<ConfigSource> tryClassPath(URI uri, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            ClassLoader useCl = classLoader != null ? classLoader : SecuritySupport.getContextClassLoader();
            ClassPathUtils.consumeAsPaths(useCl, uri.getPath(), new ConfigSourcePathConsumer(configSources));
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        catch (IllegalArgumentException e) {
            configSources.addAll(this.fallbackToUnknownProtocol(uri, classLoader));
        }
        return configSources;
    }

    protected List<ConfigSource> tryJar(URI uri) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            ClassPathUtils.consumeAsPath(AbstractLocationConfigSourceLoader.toURL(uri), new ConfigSourcePathConsumer(configSources));
        }
        catch (Exception e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        return configSources;
    }

    protected List<ConfigSource> fallbackToUnknownProtocol(URI uri, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            Enumeration<URL> resources = classLoader.getResources(uri.toString());
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                if (!this.validExtension(resourceUrl.getFile())) continue;
                ConfigSource mainSource = this.addConfigSource(resourceUrl, configSources);
                configSources.add(new ConfigurableConfigSource(profiles -> {
                    ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
                    for (int i = profiles.size() - 1; i >= 0; --i) {
                        int ordinal = mainSource.getOrdinal() + profiles.size() - i + 1;
                        URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(uri, (String)profiles.get(i));
                        try {
                            Enumeration<URL> profileResources = classLoader.getResources(profileUri.toString());
                            while (profileResources.hasMoreElements()) {
                                URL profileUrl = profileResources.nextElement();
                                this.addProfileConfigSource(profileUrl, ordinal, profileSources);
                            }
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return profileSources;
                }));
            }
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
        return configSources;
    }

    protected List<ConfigSource> tryHttpResource(URI uri) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        if (this.validExtension(uri.getPath())) {
            ConfigSource mainSource = this.addConfigSource(uri, configSources);
            configSources.addAll(this.tryProfiles(uri, mainSource));
        }
        return configSources;
    }

    protected List<ConfigSource> tryProfiles(URI uri, ConfigSource mainSource) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.add(new ConfigurableConfigSource(profiles -> {
            ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
            for (int i = profiles.size() - 1; i >= 0; --i) {
                int ordinal = mainSource.getOrdinal() + profiles.size() - i + 1;
                URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(uri, (String)profiles.get(i));
                this.addProfileConfigSource(AbstractLocationConfigSourceLoader.toURL(profileUri), ordinal, profileSources);
            }
            return profileSources;
        }));
        return configSources;
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConfigSource addConfigSource(URI uri, List<ConfigSource> configSources) {
        return this.addConfigSource(AbstractLocationConfigSourceLoader.toURL(uri), configSources);
    }

    private ConfigSource addConfigSource(URL url, List<ConfigSource> configSources) {
        try {
            ConfigSource configSource = this.loadConfigSource(url);
            if (!configSource.getPropertyNames().isEmpty()) {
                configSources.add(configSource);
            }
            return configSource;
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
    }

    private void addProfileConfigSource(URL profileToFileName, int ordinal, List<ConfigSource> profileSources) {
        try {
            ConfigSource configSource = this.loadConfigSource(profileToFileName, ordinal);
            if (!configSource.getPropertyNames().isEmpty()) {
                profileSources.add(configSource);
            }
        }
        catch (FileNotFoundException | NoSuchFileException configSource) {
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e);
        }
    }

    private boolean validExtension(Path fileName) {
        return this.validExtension(fileName.getFileName().toString());
    }

    private boolean validExtension(String resourceName) {
        for (String s : this.getFileExtensions()) {
            if (!resourceName.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static URI addProfileName(URI uri, String profile) {
        if ("jar".equals(uri.getScheme())) {
            return URI.create("jar:" + AbstractLocationConfigSourceLoader.addProfileName(URI.create(uri.getSchemeSpecificPart()), profile));
        }
        String fileName = uri.getPath();
        assert (fileName != null);
        int dot = fileName.lastIndexOf(".");
        String fileNameProfile = dot != -1 ? fileName.substring(0, dot) + "-" + profile + fileName.substring(dot) : fileName + "-" + profile;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getHost(), uri.getPort(), fileNameProfile, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    static interface ProfileConfigSourceFactory
    extends ConfigSourceFactory {
        @Override
        default public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
            List<String> profiles = context.getProfiles();
            if (profiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.getProfileConfigSources(profiles);
        }

        public Iterable<ConfigSource> getProfileConfigSources(List<String> var1);
    }

    private class ConfigSourcePathConsumer
    implements Consumer<Path> {
        private final List<ConfigSource> configSources;

        public ConfigSourcePathConsumer(List<ConfigSource> configSources) {
            this.configSources = configSources;
        }

        @Override
        public void accept(Path path) {
            AbstractLocationConfigSourceLoader loader = AbstractLocationConfigSourceLoader.this;
            if (loader.validExtension(path.getFileName().toString())) {
                ConfigSource mainSource = loader.addConfigSource(path.toUri(), (List<ConfigSource>)this.configSources);
                this.configSources.addAll(loader.tryProfiles(path.toUri(), mainSource));
            }
        }
    }

    private static class URIConverter
    implements Converter<URI> {
        private static final long serialVersionUID = -4852082279190307320L;

        private URIConverter() {
        }

        @Override
        public URI convert(String value) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw ConfigMessages.msg.uriSyntaxInvalid(e, value);
            }
        }
    }
}

