/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.Functions;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.eclipse.microprofile.config.spi.Converter;

final class ConfigMappingProvider
implements Serializable {
    private static final long serialVersionUID = 3977667610888849912L;
    private static final BiConsumer<ConfigMappingContext, NameIterator> DO_NOTHING = Functions.discardingBiConsumer();
    private static final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> IGNORE_EVERYTHING;
    private final Map<String, List<Class<?>>> roots;
    private final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions;
    private final KeyMap<String> defaultValues;
    private final boolean validateUnknown;

    ConfigMappingProvider(Builder builder) {
        this.roots = new HashMap(builder.roots);
        ArrayDeque<String> currentPath = new ArrayDeque<String>();
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        KeyMap<String> defaultValues = new KeyMap<String>();
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            NameIterator rootNi = new NameIterator(entry.getKey());
            while (rootNi.hasNext()) {
                String nextSegment = rootNi.getNextSegment();
                if (!nextSegment.isEmpty()) {
                    currentPath.add(nextSegment);
                }
                rootNi.next();
            }
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                GetRootAction ef = new GetRootAction(root, entry.getKey());
                this.processEagerGroup(currentPath, matchActions, defaultValues, ConfigMappingLoader.getConfigMappingInterface(root), ef);
            }
            currentPath.clear();
        }
        for (String[] ignoredPath : builder.ignored) {
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> found;
            int len;
            if (ignoredPath[(len = ignoredPath.length) - 1].equals("**")) {
                found = matchActions.findOrAdd(ignoredPath, 0, len - 1);
                found.putRootValue(DO_NOTHING);
                found.putAny(IGNORE_EVERYTHING);
                continue;
            }
            found = matchActions.findOrAdd(ignoredPath);
            found.putRootValue(DO_NOTHING);
        }
        this.matchActions = matchActions;
        this.defaultValues = defaultValues;
        this.validateUnknown = builder.validateUnknown;
    }

    static String skewer(Method method) {
        return ConfigMappingProvider.skewer(method.getName());
    }

    static String skewer(String camelHumps) {
        return ConfigMappingProvider.skewer(camelHumps, 0, camelHumps.length(), new StringBuilder());
    }

    static String skewer(String camelHumps, int start, int end, StringBuilder b) {
        assert (!camelHumps.isEmpty()) : "Method seems to have an empty name";
        int cp = camelHumps.codePointAt(start);
        b.appendCodePoint(Character.toLowerCase(cp));
        if ((start += Character.charCount(cp)) == end) {
            return b.toString();
        }
        if (Character.isUpperCase(cp)) {
            int nextCp = camelHumps.codePointAt(start);
            if (Character.isUpperCase(nextCp)) {
                do {
                    b.appendCodePoint(Character.toLowerCase(cp));
                    cp = nextCp;
                    if ((start += Character.charCount(cp)) != end) continue;
                    return b.toString();
                } while (!Character.isLowerCase(nextCp = camelHumps.codePointAt(start)));
                b.append('-');
                return ConfigMappingProvider.skewer(camelHumps, start, end, b);
            }
            b.appendCodePoint(nextCp);
            start += Character.charCount(nextCp);
            while (true) {
                if (start == end) {
                    return b.toString();
                }
                cp = camelHumps.codePointAt(start);
                if (Character.isUpperCase(cp)) {
                    b.append('-');
                    return ConfigMappingProvider.skewer(camelHumps, start, end, b);
                }
                b.appendCodePoint(cp);
                start += Character.charCount(cp);
            }
        }
        do {
            if (Character.isUpperCase(cp = camelHumps.codePointAt(start))) {
                b.append('-');
                return ConfigMappingProvider.skewer(camelHumps, start, end, b);
            }
            b.appendCodePoint(cp);
        } while ((start += Character.charCount(cp)) != end);
        return b.toString();
    }

    private void processEagerGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction) {
        Class<?> type = group.getInterfaceType();
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        HashSet<String> usedProperties = new HashSet<String>();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            String memberName = property.getMethod().getName();
            if (!usedProperties.add(memberName)) continue;
            if (!property.isParentPropertyName()) {
                String propertyName = property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.skewer(property.getMethod());
                NameIterator ni = new NameIterator(propertyName);
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            if (property.isOptional()) {
                ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
                if (nestedProperty.isGroup()) {
                    ConfigMappingInterface.GroupProperty nestedGroup = nestedProperty.asGroup();
                    GetOrCreateEnclosingGroupInGroup matchAction = new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, nestedGroup);
                    GetFieldOfEnclosing ef = new GetFieldOfEnclosing(nestedGroup.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction), type, memberName);
                    this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, nestedGroup, ef, matchAction, new HashSet<String>());
                } else if (nestedProperty.isLeaf()) {
                    ConfigMappingInterface.LeafProperty leafProperty = nestedProperty.asLeaf();
                    if (leafProperty.hasDefaultValue()) {
                        defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    }
                    matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
                }
            } else if (property.isGroup()) {
                this.processEagerGroup(currentPath, matchActions, defaultValues, property.asGroup().getGroupType(), new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, property.asGroup()));
            } else if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                }
                matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
            } else if (property.isLeaf()) {
                ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                }
                matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
            } else if (property.isMap()) {
                this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, group);
            }
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, group.getSuperType(i), getEnclosingFunction);
        }
    }

    private void processLazyGroupInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.GroupProperty groupProperty, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties) {
        ConfigMappingInterface group = groupProperty.getGroupType();
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            if (!property.isParentPropertyName()) {
                String propertyName = property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.skewer(property.getMethod());
                NameIterator ni = new NameIterator(propertyName);
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            if (usedProperties.add(property.getMethod().getName())) {
                boolean optional = property.isOptional();
                if (optional && property.asOptional().getNestedProperty().isGroup()) {
                    ConfigMappingInterface.GroupProperty nestedGroup = property.asOptional().getNestedProperty().asGroup();
                    GetOrCreateEnclosingGroupInGroup nestedMatchAction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction), group, nestedGroup);
                    this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, nestedGroup, nestedMatchAction, nestedMatchAction, new HashSet<String>());
                } else if (property.isGroup()) {
                    ConfigMappingInterface.GroupProperty asGroup = property.asGroup();
                    GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction), group, asGroup);
                    ConsumeOneAndThen nestedMatchAction = matchAction;
                    if (!property.isParentPropertyName()) {
                        nestedMatchAction = new ConsumeOneAndThen(nestedMatchAction);
                    }
                    this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, asGroup, nestedEnclosingFunction, nestedMatchAction, usedProperties);
                } else if (property.isLeaf() || property.isPrimitive() || optional && property.asOptional().getNestedProperty().isLeaf()) {
                    ConfigMappingInterface.LeafProperty leafProperty;
                    ConsumeOneAndThen actualAction = !property.isParentPropertyName() ? new ConsumeOneAndThen(matchAction) : matchAction;
                    matchActions.findOrAdd(currentPath).putRootValue(actualAction);
                    if (property.isPrimitive()) {
                        ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                        if (primitiveProperty.hasDefaultValue()) {
                            defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                        }
                    } else if (property.isLeaf()) {
                        leafProperty = property.asLeaf();
                        if (leafProperty.hasDefaultValue()) {
                            defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                        }
                    } else {
                        leafProperty = property.asOptional().getNestedProperty().asLeaf();
                        if (leafProperty.hasDefaultValue()) {
                            defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                        }
                    }
                } else if (property.isMap()) {
                    this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, group);
                }
            }
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, groupProperty, getEnclosingFunction, matchAction, usedProperties);
        }
    }

    private void processLazyMapInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface enclosingGroup) {
        GetOrCreateEnclosingMapInGroup getEnclosingMap = new GetOrCreateEnclosingMapInGroup(getEnclosingGroup, enclosingGroup, property);
        this.processLazyMap(currentPath, matchActions, defaultValues, property, getEnclosingMap, enclosingGroup);
    }

    private void processLazyMap(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface enclosingGroup) {
        ConfigMappingInterface.Property valueProperty = property.getValueProperty();
        Class<Converter<?>> keyConvertWith = property.hasKeyConvertWith() ? property.getKeyConvertWith() : null;
        Class<?> keyRawType = property.getKeyRawType();
        currentPath.addLast("*");
        if (valueProperty.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asLeaf();
            Class<? extends Converter<?>> valConvertWith = leafProperty.getConvertWith();
            Class<?> valueRawType = leafProperty.getValueRawType();
            matchActions.findOrAdd(currentPath).putRootValue((mc, ni) -> {
                StringBuilder sb = mc.getStringBuilder();
                sb.setLength(0);
                sb.append(ni.getAllPreviousSegments());
                String configKey = sb.toString();
                Map map = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                String rawMapKey = ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = keyConv.convert(rawMapKey);
                Converter valueConv = valConvertWith != null ? mc.getConverterInstance(valConvertWith) : config.requireConverter(valueRawType);
                map.put(key, config.getValue(configKey, valueConv));
            });
        } else if (valueProperty.isMap()) {
            this.processLazyMap(currentPath, matchActions, defaultValues, valueProperty.asMap(), (mc, ni) -> {
                ni.previous();
                Map enclosingMap = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                ni.next();
                String rawMapKey = ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = keyConv.convert(rawMapKey);
                return (Map)enclosingMap.computeIfAbsent(key, x -> new HashMap());
            }, enclosingGroup);
        } else {
            assert (valueProperty.isGroup());
            GetOrCreateEnclosingGroupInMap ef = new GetOrCreateEnclosingGroupInMap(getEnclosingMap, property, enclosingGroup, valueProperty.asGroup());
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, valueProperty.asGroup(), ef, ef, new HashSet<String>());
        }
        currentPath.removeLast();
    }

    static Map<?, ?> getOrCreateEnclosingMapInMap(ConfigMappingContext context, NameIterator ni, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty property) {
        ni.previous();
        Map<?, ?> ourEnclosing = getEnclosingMap.apply(context, ni);
        String mapKey = ni.getNextSegment();
        Converter keyConverter = context.getKeyConverter(enclosingGroup.getInterfaceType(), property.getMethod().getName(), property.getLevels() - 1);
        Object realKey = keyConverter.convert(mapKey);
        HashMap map = (HashMap)ourEnclosing.get(realKey);
        if (map == null) {
            map = new HashMap();
            ourEnclosing.put(realKey, map);
        }
        ni.next();
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    void mapConfiguration(SmallRyeConfig config) throws ConfigValidationException {
        this.mapConfiguration(config, config.getConfigMappings());
    }

    private void mapConfiguration(SmallRyeConfig config, ConfigMappings mappings) throws ConfigValidationException {
        if (this.roots.isEmpty()) {
            return;
        }
        Assert.checkNotNullParam("config", config);
        ConfigMappingContext context = new ConfigMappingContext(config);
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            String path = entry.getKey();
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), path);
                ConfigMappingObject group = (ConfigMappingObject)context.constructGroup(root);
                context.registerRoot(root, path, group);
            }
        }
        for (String name : config.getPropertyNames()) {
            if (!this.isPropertyInRoot(name)) continue;
            NameIterator ni = new NameIterator(name);
            BiConsumer<ConfigMappingContext, NameIterator> action = this.matchActions.findRootValue(ni);
            if (action != null) {
                action.accept(context, ni);
                continue;
            }
            if (!this.validateUnknown) continue;
            context.unknownConfigElement(name);
        }
        ArrayList<ConfigValidationException.Problem> problems = context.getProblems();
        if (!problems.isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        context.fillInOptionals();
        mappings.registerConfigMappings(context.getRootsMap());
    }

    private boolean isPropertyInRoot(String propertyName) {
        Set<String> registeredRoots = this.roots.keySet();
        for (String registeredRoot : registeredRoots) {
            if (!propertyName.startsWith(registeredRoot)) continue;
            return true;
        }
        return false;
    }

    static {
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> map = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        map.putRootValue(DO_NOTHING);
        IGNORE_EVERYTHING = map;
    }

    public static final class Builder {
        final Map<String, List<Class<?>>> roots = new HashMap();
        final List<String[]> ignored = new ArrayList<String[]>();
        boolean validateUnknown = true;

        Builder() {
        }

        public Builder addRoot(String path, Class<?> type) {
            Assert.checkNotNullParam("path", path);
            Assert.checkNotNullParam("type", type);
            this.roots.computeIfAbsent(path, k -> new ArrayList(4)).add(ConfigMappingLoader.getConfigMappingClass(type));
            return this;
        }

        public Builder addIgnored(String path) {
            Assert.checkNotNullParam("path", path);
            this.ignored.add(path.split("\\."));
            return this;
        }

        public Builder validateUnknown(boolean validateUnknown) {
            this.validateUnknown = validateUnknown;
            return this;
        }

        public ConfigMappingProvider build() {
            return new ConfigMappingProvider(this);
        }
    }

    static class GetFieldOfEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction;
        private final Class<?> type;
        private final String memberName;

        GetFieldOfEnclosing(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName) {
            this.getEnclosingFunction = getEnclosingFunction;
            this.type = type;
            this.memberName = memberName;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            ConfigMappingObject outer = this.getEnclosingFunction.apply(mc, ni);
            return (ConfigMappingObject)mc.getEnclosedField(this.type, this.memberName, outer);
        }
    }

    static class GetOrCreateEnclosingMapInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup;
        final ConfigMappingInterface enclosingGroup;
        final ConfigMappingInterface.MapProperty property;

        GetOrCreateEnclosingMapInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty property) {
            this.getEnclosingGroup = getEnclosingGroup;
            this.enclosingGroup = enclosingGroup;
            this.property = property;
        }

        @Override
        public Map<?, ?> apply(ConfigMappingContext context, NameIterator ni) {
            String methodName;
            Class<?> enclosingType;
            HashMap val;
            boolean consumeName;
            boolean bl = consumeName = !this.property.isParentPropertyName();
            if (consumeName) {
                ni.previous();
            }
            ConfigMappingObject ourEnclosing = this.getEnclosingGroup.apply(context, ni);
            if (consumeName) {
                ni.next();
            }
            if ((val = (HashMap)context.getEnclosedField(enclosingType = this.enclosingGroup.getInterfaceType(), methodName = this.property.getMethod().getName(), ourEnclosing)) == null) {
                val = new HashMap();
                context.registerEnclosedField(enclosingType, methodName, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInMap
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        final BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap;
        final ConfigMappingInterface.MapProperty enclosingMap;
        final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;

        GetOrCreateEnclosingGroupInMap(BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.MapProperty enclosingMap, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup) {
            this.getEnclosingMap = getEnclosingMap;
            this.enclosingMap = enclosingMap;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ni.previous();
            Map<?, ?> ourEnclosing = this.getEnclosingMap.apply(context, ni);
            ni.next();
            String mapKey = ni.getPreviousSegment();
            Converter keyConverter = context.getKeyConverter(this.enclosingGroup.getInterfaceType(), this.enclosingMap.getMethod().getName(), this.enclosingMap.getLevels() - 1);
            ConfigMappingObject val = (ConfigMappingObject)ourEnclosing.get(mapKey);
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), ni.getAllPreviousSegments());
                Object convertedKey = keyConverter.convert(mapKey);
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                ourEnclosing.put(convertedKey, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;

        GetOrCreateEnclosingGroupInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            String methodName;
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(enclosingType, methodName = this.enclosedGroup.getMethod().getName(), ourEnclosing);
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), ni.getAllPreviousSegments());
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(enclosingType, methodName, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            this.apply(context, nameIterator);
        }
    }

    static class GetRootAction
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final Class<?> root;
        private final String rootPath;

        GetRootAction(Class<?> root, String rootPath) {
            this.root = root;
            this.rootPath = rootPath;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            return mc.getRoot(this.root, this.rootPath);
        }
    }

    static final class ConsumeOneAndThenFn<T>
    implements BiFunction<ConfigMappingContext, NameIterator, T> {
        private final BiFunction<ConfigMappingContext, NameIterator, T> delegate;

        ConsumeOneAndThenFn(BiFunction<ConfigMappingContext, NameIterator, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T apply(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            T result = this.delegate.apply(context, nameIterator);
            nameIterator.next();
            return result;
        }
    }

    static final class ConsumeOneAndThen
    implements BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiConsumer<ConfigMappingContext, NameIterator> delegate;

        ConsumeOneAndThen(BiConsumer<ConfigMappingContext, NameIterator> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            this.delegate.accept(context, nameIterator);
            nameIterator.next();
        }
    }
}

