/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="compare-dependencies", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class CompareDependenciesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final int INFO_PAD_SIZE = 68;
    @Parameter(property="remotePom", required=true)
    protected String remotePom;
    @Parameter(property="ignoreRemoteDependencies", defaultValue="false")
    protected boolean ignoreRemoteDependencies;
    @Parameter(property="ignoreRemoteDependencyManagement", defaultValue="false")
    protected boolean ignoreRemoteDependencyManagement;
    @Parameter(property="updateDependencies", defaultValue="false")
    protected boolean updateDependencies;
    @Parameter(property="updatePropertyVersions", defaultValue="false")
    protected boolean updatePropertyVersions;
    @Parameter(property="reportMode", defaultValue="true")
    protected boolean reportMode;
    @Parameter(property="reportOutputFile")
    protected File reportOutputFile;
    @Component
    protected MavenProjectBuilder mavenProjectBuilder;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        String[] remotePomParts;
        if (this.ignoreRemoteDependencies && this.ignoreRemoteDependencyManagement) {
            throw new MojoFailureException(" ignoreRemoteDependencies and ignoreRemoteDependencyManagementare both set to true.  At least one of these needs to be false ");
        }
        if (this.updateDependencies) {
            this.reportMode = false;
        }
        if ((remotePomParts = this.remotePom.split(":")).length != 3) {
            throw new MojoFailureException(" Invalid format for remotePom: " + this.remotePom);
        }
        String rGroupId = remotePomParts[0];
        String rArtifactId = remotePomParts[1];
        String rVersion = remotePomParts[2];
        Dependency remoteDependency = new Dependency();
        remoteDependency.setGroupId(rGroupId);
        remoteDependency.setArtifactId(rArtifactId);
        remoteDependency.setVersion(rVersion);
        Artifact remoteArtifact = this.toArtifact(remoteDependency);
        MavenProject remoteMavenProject = null;
        try {
            remoteMavenProject = this.mavenProjectBuilder.buildFromRepository(remoteArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Unable to build remote project " + remoteArtifact, e);
        }
        HashMap<String, Dependency> remoteDepsMap = new HashMap<String, Dependency>();
        if (!this.ignoreRemoteDependencyManagement) {
            List<Dependency> remoteProjectDepMgmtDeps = remoteMavenProject.getDependencyManagement() == null ? null : remoteMavenProject.getDependencyManagement().getDependencies();
            this.mapDependencies(remoteDepsMap, remoteProjectDepMgmtDeps);
        }
        if (!this.ignoreRemoteDependencies) {
            List<Dependency> remoteProjectDeps = remoteMavenProject.getDependencies();
            this.mapDependencies(remoteDepsMap, remoteProjectDeps);
        }
        ArrayList<String> totalDiffs = new ArrayList<String>();
        ArrayList<String> propertyDiffs = new ArrayList<String>();
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            List<String> depManDiffs = this.compareVersions(pom, this.getProject().getDependencyManagement().getDependencies(), remoteDepsMap);
            totalDiffs.addAll(depManDiffs);
        }
        if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
            List<String> depDiffs = this.compareVersions(pom, this.getProject().getDependencies(), remoteDepsMap);
            totalDiffs.addAll(depDiffs);
        }
        if (this.updatePropertyVersions) {
            Map<Property, PropertyVersions> versionProperties = this.getHelper().getVersionPropertiesMap(this.getProject(), null, null, null, true);
            List<String> diff = this.updatePropertyVersions(pom, versionProperties, remoteDepsMap);
            propertyDiffs.addAll(diff);
        }
        if (this.reportMode) {
            this.getLog().info("The following differences were found:");
            if (totalDiffs.size() == 0) {
                this.getLog().info("  none");
            } else {
                for (String totalDiff : totalDiffs) {
                    this.getLog().info("  " + totalDiff);
                }
            }
            this.getLog().info("The following property differences were found:");
            if (propertyDiffs.size() == 0) {
                this.getLog().info("  none");
            } else {
                for (String propertyDiff : propertyDiffs) {
                    this.getLog().info("  " + propertyDiff);
                }
            }
        }
        if (this.reportOutputFile != null) {
            this.writeReportFile(totalDiffs, propertyDiffs);
        }
    }

    private List<String> compareVersions(ModifiedPomXMLEventReader pom, List<Dependency> dependencies, Map<String, Dependency> remoteDependencies) throws MojoExecutionException, XMLStreamException {
        ArrayList<String> updates = new ArrayList<String>();
        for (Dependency dep : dependencies) {
            Dependency remoteDep;
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact) || (remoteDep = remoteDependencies.get(dep.getManagementKey())) == null) continue;
            String remoteVersion = remoteDep.getVersion();
            if (dep.getVersion().equals(remoteVersion)) continue;
            StringBuilder buf = this.writeDependencyDiffMessage(dep, remoteVersion);
            updates.add(buf.toString());
            if (this.reportMode || !PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), remoteVersion, this.getProject().getModel())) continue;
            this.getLog().info("Updated " + this.toString(dep) + " to version " + remoteVersion);
        }
        return updates;
    }

    private List<String> updatePropertyVersions(ModifiedPomXMLEventReader pom, Map<Property, PropertyVersions> versionProperties, Map<String, Dependency> remoteDependencies) throws XMLStreamException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Property, PropertyVersions> entry : versionProperties.entrySet()) {
            String originalVersion;
            PropertyVersions version;
            Property property = entry.getKey();
            String candidateVersion = this.computeCandidateVersion(remoteDependencies, property, version = entry.getValue());
            if (candidateVersion == null || candidateVersion.equals(originalVersion = version.getAssociations()[0].getArtifact().getVersion())) continue;
            result.add(this.writeDiffMessage(property.getName(), originalVersion, candidateVersion).toString());
            if (this.reportMode || !PomHelper.setPropertyVersion(pom, null, property.getName(), candidateVersion)) continue;
            this.getLog().info("Updated ${" + property.getName() + "} from " + originalVersion + " to " + candidateVersion);
        }
        return result;
    }

    private String computeCandidateVersion(Map<String, Dependency> remoteDependencies, Property property, PropertyVersions propertyVersions) {
        String candidateVersion = null;
        for (ArtifactAssociation artifactAssociation : propertyVersions.getAssociations()) {
            String id = CompareDependenciesMojo.generateId(artifactAssociation.getArtifact());
            Dependency dependency = remoteDependencies.get(id);
            if (dependency == null) {
                this.getLog().info("Not updating ${" + property.getName() + "}: no info for " + id);
                return null;
            }
            if (candidateVersion == null) {
                candidateVersion = dependency.getVersion();
                continue;
            }
            if (candidateVersion.equals(dependency.getVersion())) continue;
            this.getLog().warn("Could not update ${" + property.getName() + "}: version mismatch");
            return null;
        }
        return candidateVersion;
    }

    private void writeReportFile(List<String> dependenciesUpdate, List<String> propertiesUpdate) throws MojoExecutionException {
        if (!this.reportOutputFile.getParentFile().exists()) {
            this.reportOutputFile.getParentFile().mkdirs();
        }
        try (FileWriter fw = new FileWriter(this.reportOutputFile);
             PrintWriter pw = new PrintWriter(fw);){
            pw.println("The following differences were found:");
            pw.println();
            if (dependenciesUpdate.size() == 0) {
                pw.println("  none");
            } else {
                for (String dependencyUpdate : dependenciesUpdate) {
                    pw.println("  " + dependencyUpdate);
                }
            }
            pw.println();
            pw.println("The following property differences were found:");
            pw.println();
            if (propertiesUpdate.size() == 0) {
                pw.println("  none");
            } else {
                for (String propertyUpdate : propertiesUpdate) {
                    pw.println("  " + propertyUpdate);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write report file. ", e);
        }
    }

    private StringBuilder writeDependencyDiffMessage(Dependency dep, String remoteVersion) {
        String id = dep.getGroupId() + ":" + dep.getArtifactId();
        return this.writeDiffMessage(id, dep.getVersion(), remoteVersion);
    }

    private StringBuilder writeDiffMessage(String id, String originalVersion, String targetVersion) {
        StringBuilder buf = new StringBuilder();
        buf.append(id);
        buf.append(' ');
        int padding = 68 - originalVersion.length() - targetVersion.length() - 4;
        while (buf.length() < padding) {
            buf.append('.');
        }
        buf.append(' ');
        buf.append(originalVersion);
        buf.append(" -> ");
        buf.append(targetVersion);
        return buf;
    }

    private void mapDependencies(Map<String, Dependency> map, List<Dependency> deps) {
        if (deps != null) {
            for (Dependency nextDep : deps) {
                map.put(nextDep.getManagementKey(), nextDep);
            }
        }
    }

    private static String generateId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getType());
        if (artifact.getClassifier() != null) {
            sb.append(":").append(artifact.getClassifier());
        }
        return sb.toString();
    }
}

