/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="update-child-modules", requiresProject=true, requiresDirectInvocation=true, aggregator=true, threadSafe=true)
public class UpdateChildModulesMojo
extends AbstractVersionsUpdaterMojo {
    private transient String sourceGroupId = null;
    private transient String sourceArtifactId = null;
    private transient String sourceVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean didSomething = false;
        try {
            final Map<String, Model> reactor = PomHelper.getReactorModels(this.getProject(), this.getLog());
            ArrayList<String> order = new ArrayList<String>(reactor.keySet());
            Collections.sort(order, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int d2;
                    Model m1 = (Model)reactor.get(o1);
                    Model m2 = (Model)reactor.get(o2);
                    int d1 = PomHelper.getReactorParentCount(reactor, m1);
                    if (d1 < (d2 = PomHelper.getReactorParentCount(reactor, m2))) {
                        return -1;
                    }
                    if (d1 > d2) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (String sourcePath : order) {
                Model sourceModel = reactor.get(sourcePath);
                this.getLog().debug(sourcePath.length() == 0 ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent.");
                UpdateChildModulesMojo updateChildModulesMojo = this;
                synchronized (updateChildModulesMojo) {
                    this.sourceGroupId = PomHelper.getGroupId(sourceModel);
                    if (this.sourceGroupId == null) {
                        this.getLog().warn("Module " + sourcePath + " is missing a groupId.");
                        continue;
                    }
                    this.sourceArtifactId = PomHelper.getArtifactId(sourceModel);
                    if (this.sourceArtifactId == null) {
                        this.getLog().warn("Module " + sourcePath + " is missing an artifactId.");
                        continue;
                    }
                    this.sourceVersion = PomHelper.getVersion(sourceModel);
                    if (this.sourceVersion == null) {
                        this.getLog().warn("Module " + sourcePath + " is missing a version.");
                        continue;
                    }
                    this.getLog().debug("Looking for modules which use " + ArtifactUtils.versionlessKey(this.sourceGroupId, this.sourceArtifactId) + " as their parent to update it to " + this.sourceVersion);
                    for (Map.Entry<String, Model> target : PomHelper.getChildModels(reactor, this.sourceGroupId, this.sourceArtifactId).entrySet()) {
                        String targetPath = target.getKey();
                        File moduleDir = new File(this.getProject().getBasedir(), targetPath);
                        File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
                        Model targetModel = target.getValue();
                        Parent parent = targetModel.getParent();
                        if (this.sourceVersion.equals(parent.getVersion())) {
                            this.getLog().debug("Module: " + targetPath + " parent is " + ArtifactUtils.versionlessKey(this.sourceGroupId, this.sourceArtifactId) + ":" + this.sourceVersion);
                            continue;
                        }
                        this.getLog().info("Module: " + targetPath);
                        this.getLog().info("    parent was " + ArtifactUtils.versionlessKey(this.sourceGroupId, this.sourceArtifactId) + ":" + parent.getVersion());
                        this.getLog().info("    updated to " + ArtifactUtils.versionlessKey(this.sourceGroupId, this.sourceArtifactId) + ":" + this.sourceVersion);
                        this.process(moduleProjectFile);
                        didSomething = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (!didSomething) {
            this.getLog().info("All child modules are up to date.");
        }
    }

    @Override
    protected synchronized void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        this.getLog().debug("Updating parent to " + this.sourceVersion);
        if (PomHelper.setProjectParentVersion(pom, this.sourceVersion)) {
            this.getLog().debug("Made an update to " + this.sourceVersion);
        }
    }
}

