/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.ordering.AbstractVersionComparator;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.plexus.util.StringUtils;

public class MavenVersionComparator
extends AbstractVersionComparator {
    @Override
    public int compare(ArtifactVersion o1, ArtifactVersion o2) {
        return o1.compareTo(o2);
    }

    @Override
    protected int innerGetSegmentCount(ArtifactVersion v) {
        if (v.getBuildNumber() != 0) {
            return 4;
        }
        if ((v.getMajorVersion() != 0 || v.getMinorVersion() != 0 || v.getIncrementalVersion() != 0) && v.getQualifier() != null) {
            return 4;
        }
        String version = v.toString();
        if (version.indexOf(45) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 4;
        }
        if (version.indexOf(46) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 3;
        }
        if (StringUtils.isEmpty(version)) {
            return 3;
        }
        try {
            Integer.parseInt(version);
            return 3;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    protected ArtifactVersion innerIncrementSegment(ArtifactVersion v, int segment) {
        int segmentCount = this.innerGetSegmentCount(v);
        if (segment < 0 || segment >= segmentCount) {
            throw new InvalidSegmentException(segment, segmentCount, v.toString());
        }
        String version = v.toString();
        if (segmentCount == 1) {
            version = VersionComparators.alphaNumIncrement(version);
            return new DefaultArtifactVersion(version);
        }
        int major = v.getMajorVersion();
        int minor = v.getMinorVersion();
        int incremental = v.getIncrementalVersion();
        int build = v.getBuildNumber();
        String qualifier = v.getQualifier();
        int minorIndex = version.indexOf(46);
        boolean haveMinor = minorIndex != -1;
        int incrementalIndex = haveMinor ? version.indexOf(46, minorIndex + 1) : -1;
        boolean haveIncremental = incrementalIndex != -1;
        int buildIndex = version.indexOf(45);
        boolean haveBuild = buildIndex != -1 && qualifier == null;
        boolean haveQualifier = buildIndex != -1 && qualifier != null;
        switch (segment) {
            case 0: {
                ++major;
                minor = 0;
                incremental = 0;
                build = 0;
                qualifier = null;
                break;
            }
            case 1: {
                ++minor;
                incremental = 0;
                build = 0;
                if (!haveQualifier || !qualifier.endsWith("SNAPSHOT")) break;
                qualifier = "SNAPSHOT";
                break;
            }
            case 2: {
                ++incremental;
                build = 0;
                qualifier = null;
                break;
            }
            case 3: {
                if (haveQualifier) {
                    qualifier = this.qualifierIncrement(qualifier);
                    break;
                }
                ++build;
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(major);
        if (haveMinor || minor > 0 || incremental > 0) {
            result.append('.');
            result.append(minor);
        }
        if (haveIncremental || incremental > 0) {
            result.append('.');
            result.append(incremental);
        }
        if (haveQualifier && qualifier != null) {
            result.append('-');
            result.append(qualifier);
        } else if (haveBuild || build > 0) {
            result.append('-');
            result.append(build);
        }
        return new DefaultArtifactVersion(result.toString());
    }

    private String qualifierIncrement(String qualifier) {
        if (qualifier.toLowerCase().startsWith("alpha")) {
            return qualifier.substring(0, 5) + VersionComparators.alphaNumIncrement(qualifier.substring(5));
        }
        if (qualifier.toLowerCase().startsWith("beta")) {
            return qualifier.substring(0, 4) + VersionComparators.alphaNumIncrement(qualifier.substring(4));
        }
        if (qualifier.toLowerCase().startsWith("milestone")) {
            return qualifier.substring(0, 8) + VersionComparators.alphaNumIncrement(qualifier.substring(8));
        }
        if (qualifier.toLowerCase().startsWith("cr") || qualifier.toLowerCase().startsWith("rc") || qualifier.toLowerCase().startsWith("sp")) {
            return qualifier.substring(0, 2) + VersionComparators.alphaNumIncrement(qualifier.substring(2));
        }
        return VersionComparators.alphaNumIncrement(qualifier);
    }
}

