/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SingleThreadedExecutorService
implements ExecutorService {
    private boolean shutdown;
    private Random random = new Random();

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public synchronized boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        if (!this.shutdown) {
            this.wait(TimeUnit.MILLISECONDS.convert(l, timeUnit));
        }
        return this.shutdown;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return new FuturePast<T>(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return new FuturePast<T>(new RunAndReturn<T>(t, runnable));
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return new FuturePast<Runnable>(new RunAndReturn<Runnable>(runnable, null));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(collection.size());
        for (Callable<T> callable : collection) {
            futures.add(new FuturePast<T>(callable));
        }
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.invokeAll(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> items = new ArrayList<Callable<T>>(collection);
        Callable<T> callable = null;
        while (callable == null) {
            callable = items.get(Math.abs(this.random.nextInt(items.size())));
        }
        try {
            return (T)callable.call();
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to call: " + callable, e);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(collection);
    }

    @Override
    public void execute(Runnable runnable) {
        runnable.run();
    }

    private final class FuturePast<T>
    implements Future<T> {
        private ExecutionException error;
        private T result;

        public FuturePast(T result) {
            this.result = result;
        }

        public FuturePast(Callable<? extends T> callable) {
            try {
                this.result = callable.call();
            }
            catch (Exception e) {
                this.error = new ExecutionException("Failed to call: " + callable, e);
            }
        }

        @Override
        public boolean cancel(boolean b) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private final class RunAndReturn<T>
    implements Callable<T> {
        private final T result;
        private final Runnable runnable;

        public RunAndReturn(T result, Runnable runnable) {
            this.result = result;
            this.runnable = runnable;
        }

        @Override
        public T call() throws Exception {
            this.runnable.run();
            return this.result;
        }
    }
}

