/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.rel;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.DependencyScope;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;

public final class SimpleDependencyRelationship
extends AbstractSimpleProjectRelationship<DependencyRelationship, ArtifactRef>
implements Serializable,
DependencyRelationship {
    private static final long serialVersionUID = 1L;
    private final DependencyScope scope;
    private final Set<ProjectRef> excludes;
    private boolean optional;

    public SimpleDependencyRelationship(URI source, ProjectVersionRef declaring, ArtifactRef target, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional, ProjectRef ... excludes) {
        super(source, RelationshipType.DEPENDENCY, declaring, target, index, managed, inherited, false);
        this.scope = scope == null ? DependencyScope.compile : scope;
        this.optional = optional;
        this.excludes = new HashSet<ProjectRef>(Arrays.asList(excludes));
    }

    public SimpleDependencyRelationship(URI source, URI pomLocation, ProjectVersionRef declaring, ArtifactRef target, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional, ProjectRef ... excludes) {
        super(source, pomLocation, RelationshipType.DEPENDENCY, declaring, target, index, managed, inherited, false);
        this.scope = scope == null ? DependencyScope.compile : scope;
        this.optional = optional;
        this.excludes = new HashSet<ProjectRef>(Arrays.asList(excludes));
    }

    public SimpleDependencyRelationship(Collection<URI> sources, ProjectVersionRef declaring, ArtifactRef target, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional, ProjectRef ... excludes) {
        super(sources, RelationshipType.DEPENDENCY, declaring, target, index, managed, inherited, false);
        this.scope = scope == null ? DependencyScope.compile : scope;
        this.optional = optional;
        this.excludes = new HashSet<ProjectRef>(Arrays.asList(excludes));
    }

    public SimpleDependencyRelationship(Collection<URI> sources, URI pomLocation, ProjectVersionRef declaring, ArtifactRef target, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional, ProjectRef ... excludes) {
        super(sources, pomLocation, RelationshipType.DEPENDENCY, declaring, target, index, managed, inherited, false);
        this.scope = scope == null ? DependencyScope.compile : scope;
        this.optional = optional;
        this.excludes = new HashSet<ProjectRef>(Arrays.asList(excludes));
    }

    public SimpleDependencyRelationship(DependencyRelationship relationship) {
        super(relationship);
        this.scope = relationship.getScope();
        this.optional = relationship.isOptional();
        this.excludes = new HashSet<ProjectRef>(relationship.getExcludes());
    }

    @Override
    public final DependencyScope getScope() {
        return this.scope;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public synchronized DependencyRelationship cloneFor(ProjectVersionRef projectRef) {
        return new SimpleDependencyRelationship(this.getSources(), this.getPomLocation(), projectRef, (ArtifactRef)this.getTarget(), this.scope, this.getIndex(), this.isManaged(), this.isInherited(), this.optional, new ProjectRef[0]);
    }

    @Override
    public DependencyRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimpleDependencyRelationship(srcs, this.getPomLocation(), this.getDeclaring(), (ArtifactRef)this.getTarget(), this.scope, this.getIndex(), this.isManaged(), this.isInherited(), this.optional, new ProjectRef[0]);
    }

    @Override
    public DependencyRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimpleDependencyRelationship(srcs, this.getPomLocation(), this.getDeclaring(), (ArtifactRef)this.getTarget(), this.scope, this.getIndex(), this.isManaged(), this.isInherited(), this.optional, new ProjectRef[0]);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isManaged() ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DependencyRelationship)) {
            return false;
        }
        DependencyRelationship other = (DependencyRelationship)obj;
        return this.isManaged() == other.isManaged();
    }

    public String toString() {
        return String.format("DependencyRelationship [%s => %s (managed=%s, scope=%s, index=%s)]", new Object[]{this.getDeclaring(), this.getTarget(), this.isManaged(), this.scope, this.getIndex()});
    }

    @Override
    protected ArtifactRef cloneTarget(ArtifactRef target) {
        return new SimpleArtifactRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return (ArtifactRef)this.getTarget();
    }

    @Override
    public Set<ProjectRef> getExcludes() {
        return this.excludes;
    }

    @Override
    public DependencyRelationship selectDeclaring(ProjectVersionRef ref) {
        ArtifactRef t = (ArtifactRef)this.getTarget();
        Set<ProjectRef> var = this.getExcludes();
        return new SimpleDependencyRelationship(this.getSources(), this.getPomLocation(), ref, t, this.getScope(), this.getIndex(), this.isManaged(), this.isInherited(), this.optional, var.toArray(new ProjectRef[var.size()]));
    }

    @Override
    public DependencyRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        ArtifactRef t = (ArtifactRef)this.getTarget();
        t = (ArtifactRef)(ref instanceof ArtifactRef ? ref : new SimpleArtifactRef(ref, t.getType(), t.getClassifier()));
        Set<ProjectRef> var = this.getExcludes();
        return new SimpleDependencyRelationship(this.getSources(), this.getPomLocation(), d, t, this.getScope(), this.getIndex(), this.isManaged(), this.isInherited(), this.optional, var.toArray(new ProjectRef[var.size()]));
    }

    @Override
    public boolean isBOM() {
        return DependencyScope._import == this.getScope() && "pom".equals(this.getTargetArtifact().getType());
    }
}

