/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.atlas.ident.jackson.ProjectRefDeserializer;
import org.commonjava.maven.atlas.ident.jackson.ProjectRefKeyDeserializer;
import org.commonjava.maven.atlas.ident.jackson.ProjectRefSerializer;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleVersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectVersionRefSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends ProjectRef>> REF_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ProjectRef.class, ProjectVersionRef.class, ArtifactRef.class, VersionlessArtifactRef.class, SimpleProjectRef.class, SimpleProjectVersionRef.class, SimpleArtifactRef.class, SimpleVersionlessArtifactRef.class)));
    public static final ProjectVersionRefSerializerModule INSTANCE = new ProjectVersionRefSerializerModule();

    public ProjectVersionRefSerializerModule() {
        super("ProjectRef (with variants) Serializer");
        for (Class<? extends ProjectRef> cls : REF_CLASSES) {
            this.register(cls);
        }
    }

    private <T extends ProjectRef> void register(Class<T> cls) {
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        logger2.debug("Registering {} serializers/deserialers", (Object)cls.getSimpleName());
        this.addSerializer(cls, new ProjectRefSerializer<T>(cls, false));
        this.addKeySerializer(cls, new ProjectRefSerializer<T>(cls, true));
        this.addDeserializer(cls, new ProjectRefDeserializer<T>(cls));
        this.addKeyDeserializer(cls, new ProjectRefKeyDeserializer<T>(cls));
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode() + 17;
    }

    public boolean equals(Object other) {
        return this.getClass().equals(other.getClass());
    }
}

