/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.util.VersionUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMaven350PluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Project {
    private static final MavenPluginDefaults PLUGIN_DEFAULTS = new StandardMaven350PluginDefaults();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File pom;
    private final Model model;
    private boolean inheritanceRoot;
    private boolean executionRoot;
    private boolean incrementalPME;
    private Project projectParent;

    public Project(File pom, Model model) throws ManipulationException {
        this.pom = pom;
        this.model = model;
        if (model == null) {
            throw new ManipulationException("Invalid null model.", new String[0]);
        }
        if (model.getVersion() == null && model.getParent() == null) {
            throw new ManipulationException("Invalid model: " + model + " Cannot find version!", new String[0]);
        }
    }

    public Project(Model model) throws ManipulationException {
        this(model.getPomFile(), model);
    }

    public Project(Project original) {
        this.pom = original.pom;
        this.model = original.model.clone();
        this.inheritanceRoot = original.inheritanceRoot;
        this.executionRoot = original.executionRoot;
        this.incrementalPME = original.incrementalPME;
        if (original.projectParent != null) {
            this.projectParent = new Project(original.projectParent);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getArtifactId().hashCode();
        result = 31 * result + this.getGroupId().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.getGroupId().equals(other.getGroupId()) && this.getArtifactId().equals(other.getArtifactId()) && VersionUtils.createFromSpec(this.getVersion()).equals(VersionUtils.createFromSpec(other.getVersion()));
    }

    public String toString() {
        return this.getKey() + " [pom=" + this.pom + "]";
    }

    public File getPom() {
        return this.pom;
    }

    public Model getModel() {
        return this.model;
    }

    public ProjectVersionRef getKey() {
        return new SimpleProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    public Parent getModelParent() {
        return this.model.getParent();
    }

    public String getGroupId() {
        String g = this.model.getGroupId();
        if (g == null) {
            g = this.model.getParent().getGroupId();
        }
        return g;
    }

    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    public String getVersion() {
        String v = this.model.getVersion();
        if (v == null) {
            v = this.model.getParent().getVersion();
        }
        return v;
    }

    public Map<Profile, Map<ArtifactRef, Dependency>> getResolvedProfileDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<Profile, Map<ArtifactRef, Dependency>> resolvedProfileDependencies = new HashMap<Profile, Map<ArtifactRef, Dependency>>();
        for (Profile profile : ProfileUtils.getProfiles(session, this.model)) {
            HashMap<ArtifactRef, Dependency> profileDeps = new HashMap<ArtifactRef, Dependency>();
            this.resolveDeps(session, profile.getDependencies(), false, profileDeps);
            resolvedProfileDependencies.put(profile, profileDeps);
        }
        return resolvedProfileDependencies;
    }

    public Map<Profile, Map<ArtifactRef, Dependency>> getAllResolvedProfileDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<Profile, Map<ArtifactRef, Dependency>> allResolvedProfileDependencies = new HashMap<Profile, Map<ArtifactRef, Dependency>>();
        for (Profile profile : ProfileUtils.getProfiles(session, this.model)) {
            HashMap<ArtifactRef, Dependency> profileDeps = new HashMap<ArtifactRef, Dependency>();
            this.resolveDeps(session, profile.getDependencies(), true, profileDeps);
            allResolvedProfileDependencies.put(profile, profileDeps);
        }
        return allResolvedProfileDependencies;
    }

    public Map<Profile, Map<ArtifactRef, Dependency>> getResolvedProfileManagedDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<Profile, Map<ArtifactRef, Dependency>> resolvedProfileManagedDependencies = new HashMap<Profile, Map<ArtifactRef, Dependency>>();
        for (Profile profile : ProfileUtils.getProfiles(session, this.model)) {
            HashMap<ArtifactRef, Dependency> profileDeps = new HashMap<ArtifactRef, Dependency>();
            DependencyManagement dm = profile.getDependencyManagement();
            if (dm != null) {
                this.resolveDeps(session, dm.getDependencies(), false, profileDeps);
            }
            resolvedProfileManagedDependencies.put(profile, profileDeps);
        }
        return resolvedProfileManagedDependencies;
    }

    public Map<ProjectVersionRef, Plugin> getResolvedPlugins(MavenSessionHandler session) throws ManipulationException {
        HashMap<ProjectVersionRef, Plugin> resolvedPlugins = new HashMap<ProjectVersionRef, Plugin>();
        if (this.getModel().getBuild() != null) {
            this.resolvePlugins(session, this.getModel().getBuild().getPlugins(), resolvedPlugins);
        }
        return resolvedPlugins;
    }

    public Map<ProjectVersionRef, Plugin> getResolvedManagedPlugins(MavenSessionHandler session) throws ManipulationException {
        PluginManagement pm;
        HashMap<ProjectVersionRef, Plugin> resolvedManagedPlugins = new HashMap<ProjectVersionRef, Plugin>();
        if (this.getModel().getBuild() != null && (pm = this.getModel().getBuild().getPluginManagement()) != null && pm.getPlugins() != null) {
            this.resolvePlugins(session, pm.getPlugins(), resolvedManagedPlugins);
        }
        return resolvedManagedPlugins;
    }

    public Map<Profile, Map<ProjectVersionRef, Plugin>> getResolvedProfilePlugins(MavenSessionHandler session) throws ManipulationException {
        HashMap<Profile, Map<ProjectVersionRef, Plugin>> resolvedProfilePlugins = new HashMap<Profile, Map<ProjectVersionRef, Plugin>>();
        for (Profile profile : ProfileUtils.getProfiles(session, this.model)) {
            HashMap<ProjectVersionRef, Plugin> profileDeps = new HashMap<ProjectVersionRef, Plugin>();
            if (profile.getBuild() != null) {
                this.resolvePlugins(session, profile.getBuild().getPlugins(), profileDeps);
            }
            resolvedProfilePlugins.put(profile, profileDeps);
        }
        return resolvedProfilePlugins;
    }

    public Map<Profile, Map<ProjectVersionRef, Plugin>> getResolvedProfileManagedPlugins(MavenSessionHandler session) throws ManipulationException {
        HashMap<Profile, Map<ProjectVersionRef, Plugin>> resolvedProfileManagedPlugins = new HashMap<Profile, Map<ProjectVersionRef, Plugin>>();
        for (Profile profile : ProfileUtils.getProfiles(session, this.model)) {
            PluginManagement pm;
            HashMap<ProjectVersionRef, Plugin> profileDeps = new HashMap<ProjectVersionRef, Plugin>();
            if (profile.getBuild() != null && (pm = profile.getBuild().getPluginManagement()) != null) {
                this.resolvePlugins(session, pm.getPlugins(), profileDeps);
            }
            resolvedProfileManagedPlugins.put(profile, profileDeps);
        }
        return resolvedProfileManagedPlugins;
    }

    public Map<ArtifactRef, Dependency> getResolvedDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> resolvedDependencies = new HashMap<ArtifactRef, Dependency>();
        this.resolveDeps(session, this.getModel().getDependencies(), false, resolvedDependencies);
        return resolvedDependencies;
    }

    public Map<ArtifactRef, Dependency> getAllResolvedDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> allResolvedDependencies = new HashMap<ArtifactRef, Dependency>();
        this.resolveDeps(session, this.getModel().getDependencies(), true, allResolvedDependencies);
        return allResolvedDependencies;
    }

    public Map<ArtifactRef, Dependency> getResolvedManagedDependencies(MavenSessionHandler session) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> resolvedManagedDependencies = new HashMap<ArtifactRef, Dependency>();
        DependencyManagement dm = this.getModel().getDependencyManagement();
        if (dm != null && dm.getDependencies() != null) {
            this.resolveDeps(session, dm.getDependencies(), false, resolvedManagedDependencies);
        }
        return resolvedManagedDependencies;
    }

    private void resolveDeps(MavenSessionHandler session, List<Dependency> deps, boolean includeManagedDependencies, Map<ArtifactRef, Dependency> resolvedDependencies) throws ManipulationException {
        ListIterator<Dependency> iterator = deps.listIterator(deps.size());
        while (iterator.hasPrevious()) {
            Dependency d = iterator.previous();
            if (session.getExcludedScopes().contains(d.getScope())) {
                this.logger.debug("Ignoring dependency {} as scope matched {}", (Object)d, (Object)session.getExcludedScopes());
                continue;
            }
            String g = PropertyResolver.resolveInheritedProperties(session, this, "${project.groupId}".equals(d.getGroupId()) ? this.getGroupId() : d.getGroupId());
            String a = PropertyResolver.resolveInheritedProperties(session, this, "${project.artifactId}".equals(d.getArtifactId()) ? this.getArtifactId() : d.getArtifactId());
            String v = PropertyResolver.resolveInheritedProperties(session, this, d.getVersion());
            if (includeManagedDependencies && StringUtils.isEmpty(v)) {
                v = "*";
            }
            if (!StringUtils.isNotEmpty(g) || !StringUtils.isNotEmpty(a) || !StringUtils.isNotEmpty(v)) continue;
            SimpleArtifactRef sar = new SimpleArtifactRef(g, a, v, d.getType(), d.getClassifier());
            if (resolvedDependencies.containsKey(sar)) {
                this.logger.error("Found duplicate entry within dependency list. Key of {} and dependency {}", (Object)sar, (Object)d);
                iterator.remove();
                continue;
            }
            Dependency old = resolvedDependencies.put(sar, d);
            if (old == null) continue;
            this.logger.error("Internal project dependency resolution failure ; replaced {} in store by {}:{}:{}.", old, g, a, v);
            throw new ManipulationException("Internal project dependency resolution failure ; replaced " + old + " by " + d, new String[0]);
        }
    }

    private void resolvePlugins(MavenSessionHandler session, List<Plugin> plugins, Map<ProjectVersionRef, Plugin> resolvedPlugins) throws ManipulationException {
        ListIterator<Plugin> iterator = plugins.listIterator(plugins.size());
        while (iterator.hasPrevious()) {
            Plugin p = iterator.previous();
            String g = PropertyResolver.resolveInheritedProperties(session, this, "${project.groupId}".equals(p.getGroupId()) ? this.getGroupId() : p.getGroupId());
            String a = PropertyResolver.resolveInheritedProperties(session, this, "${project.artifactId}".equals(p.getArtifactId()) ? this.getArtifactId() : p.getArtifactId());
            String v = PropertyResolver.resolveInheritedProperties(session, this, p.getVersion());
            if (StringUtils.isEmpty(g)) {
                g = PLUGIN_DEFAULTS.getDefaultGroupId(a);
            }
            if (!StringUtils.isNotEmpty(g) || !StringUtils.isNotEmpty(a) || !StringUtils.isNotEmpty(v)) continue;
            SimpleProjectVersionRef spv = new SimpleProjectVersionRef(g, a, v);
            if (resolvedPlugins.containsKey(spv)) {
                this.logger.error("Found duplicate entry within plugin list. Key of {} and plugin {}", (Object)spv, (Object)p);
                iterator.remove();
                continue;
            }
            Plugin old = resolvedPlugins.put(spv, p);
            if (old == null) continue;
            this.logger.error("Internal project plugin resolution failure ; replaced {} in store by {}.", (Object)old, (Object)spv);
            throw new ManipulationException("Internal project plugin resolution failure ; replaced " + old + " by " + spv, new String[0]);
        }
    }

    public void setInheritanceRoot(boolean inheritanceRoot) {
        this.inheritanceRoot = inheritanceRoot;
    }

    public boolean isInheritanceRoot() {
        return this.inheritanceRoot;
    }

    public void setExecutionRoot() {
        this.executionRoot = true;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }

    public void setIncrementalPME(boolean incrementalPME) {
        this.incrementalPME = incrementalPME;
    }

    public boolean isIncrementalPME() {
        return this.incrementalPME;
    }

    public void setProjectParent(Project parent) {
        this.projectParent = parent;
    }

    public Project getProjectParent() {
        return this.projectParent;
    }

    public List<Project> getInheritedList() {
        ArrayList<Project> found = new ArrayList<Project>();
        found.add(this);
        Project loop = this;
        while (loop.getProjectParent() != null) {
            found.add(0, loop.getProjectParent());
            loop = loop.getProjectParent();
        }
        return found;
    }

    public List<Project> getReverseInheritedList() {
        ArrayList<Project> found = new ArrayList<Project>();
        found.add(this);
        Project loop = this;
        while (loop.getProjectParent() != null) {
            found.add(loop.getProjectParent());
            loop = loop.getProjectParent();
        }
        return found;
    }

    public void updateProfiles(List<Profile> remoteProfiles) {
        List<Profile> profiles = this.model.getProfiles();
        if (!remoteProfiles.isEmpty()) {
            for (Profile profile : remoteProfiles) {
                Iterator<Profile> i = profiles.iterator();
                while (i.hasNext()) {
                    Profile p = i.next();
                    if (profile.getId().equals(p.getId())) {
                        this.logger.debug("Removing local profile {} ", (Object)p);
                        i.remove();
                    }
                    if (p.getActivation() == null || !p.getActivation().isActiveByDefault()) continue;
                    this.logger.warn("Profile {} is activeByDefault", (Object)p);
                    Activation replacement = new Activation();
                    ActivationProperty replacementProp = new ActivationProperty();
                    replacementProp.setName("!disableProfileActivation");
                    replacement.setProperty(replacementProp);
                    p.setActivation(replacement);
                }
                this.logger.debug("Adding profile {}", (Object)profile);
                profiles.add(profile);
            }
        }
    }
}

