/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.MavenBaseScript;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.io.rest.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScriptUtils
extends Script
implements MavenBaseScript {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void inlineProperty(Project currentProject, ProjectRef groupArtifact) throws ManipulationException {
        try {
            currentProject.getResolvedManagedDependencies(this.getSession()).entrySet().stream().filter(a -> ((ArtifactRef)a.getKey()).asProjectRef().equals(groupArtifact) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.info("Found managed artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
            currentProject.getResolvedDependencies(this.getSession()).entrySet().stream().filter(a -> ((ArtifactRef)a.getKey()).asProjectRef().equals(groupArtifact) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.info("Found artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    public void inlineProperty(Project currentProject, String propertyKey) throws ManipulationException {
        try {
            currentProject.getResolvedManagedDependencies(this.getSession()).entrySet().stream().filter(a -> ((Dependency)a.getValue()).getVersion().equals("${" + propertyKey + "}")).forEach(a -> {
                this.logger.info("Found managed artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
            currentProject.getResolvedDependencies(this.getSession()).entrySet().stream().filter(a -> ((Dependency)a.getValue()).getVersion().equals("${" + propertyKey + "}")).forEach(a -> {
                this.logger.info("Found artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private void validateSession() throws ManipulationException {
        if (!(this.getSession() instanceof ManipulationSession)) {
            throw new ManipulationException("Unable to access session instance in " + this.getSession(), new String[0]);
        }
    }

    public void reinitialiseSessionStates() throws ManipulationException {
        this.validateSession();
        ((ManipulationSession)this.getSession()).reinitialiseStates();
    }

    private Translator getRESTAPI() throws ManipulationException {
        this.validateSession();
        RESTState rs = ((ManipulationSession)this.getSession()).getState(RESTState.class);
        return rs.getVersionTranslator();
    }

    public void overrideProjectVersion(ProjectVersionRef gav) throws ManipulationException {
        ArrayList<ProjectVersionRef> source = new ArrayList<ProjectVersionRef>();
        source.add(gav);
        source.add(this.getGAV());
        Map<ProjectVersionRef, String> restResult = this.getRESTAPI().translateVersions(source);
        String targetBuild = restResult.get(gav);
        String thisMapping = restResult.get(this.getGAV());
        if (targetBuild == null) {
            this.logger.error("REST result was {}", (Object)restResult);
            throw new ManipulationException("Multiple results returned ; unable to reset version.", new String[0]);
        }
        if (thisMapping != null) {
            this.logger.info("Comparing target GAV build {} to this build {} ", (Object)targetBuild, (Object)thisMapping);
            if (Version.getIntegerBuildNumber(thisMapping) >= Version.getIntegerBuildNumber(targetBuild)) {
                this.logger.error("Alignment failure: Target is {} and this is {}", (Object)Version.getIntegerBuildNumber(targetBuild), (Object)Version.getIntegerBuildNumber(thisMapping));
                throw new ManipulationException("Unable to set version suffix as dependent build has been built more or the same number of times than the original target", new String[0]);
            }
        }
        String newSuffix = targetBuild.substring(gav.getVersionString().length() + 1);
        this.logger.info("From version {}, updating versionSuffix to {}", (Object)targetBuild, (Object)newSuffix);
        this.getUserProperties().put(VersioningState.VERSION_SUFFIX_SYSPROP.getCurrent(), newSuffix);
        this.reinitialiseSessionStates();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

