/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.ParentInjectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="parent-injection")
@Singleton
public class ParentInjectionManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new ParentInjectionState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) {
        ParentInjectionState state = this.session.getState(ParentInjectionState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        projects.stream().filter(Project::isInheritanceRoot).forEach(p -> {
            this.logger.debug("Injecting parent reference {} ", (Object)state.getParentInjection());
            p.getModel().setParent(state.getParentInjection());
            changed.add((Project)p);
        });
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return 25;
    }
}

