/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.PropertyInterpolator;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.impl.VersionCalculator;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="version-manipulator")
@Singleton
public class ProjectVersioningManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private VersionCalculator calculator;
    private ManipulationSession session;

    @Inject
    public ProjectVersioningManipulator(VersionCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new VersioningState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        VersioningState state = this.session.getState(VersioningState.class);
        if (!this.session.isEnabled() || state == null || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        this.logger.info("Version Manipulator: Calculating the necessary versioning changes.");
        state.setVersionsByGAVMap(this.calculator.calculateVersioningChanges(projects, this.session));
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            if (!this.applyVersioningChanges(project, state)) continue;
            changed.add(project);
        }
        return changed;
    }

    protected boolean applyVersioningChanges(Project project, VersioningState state) throws ManipulationException {
        String newVersion;
        SimpleProjectVersionRef parentGAV;
        if (!state.hasVersionsByGAV()) {
            return false;
        }
        Model model = project.getModel();
        Parent parent = model.getParent();
        Map<ProjectVersionRef, String> versionsByGAV = state.getVersionsByGAV();
        ProjectVersionRef gav = project.getKey();
        boolean changed = false;
        if (parent != null && parent.getVersion() != null && versionsByGAV.containsKey(parentGAV = new SimpleProjectVersionRef(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()))) {
            String newVersion2 = versionsByGAV.get(parentGAV);
            this.logger.debug("Changed parent version to: {} in {}", (Object)newVersion2, (Object)parent);
            if (parentGAV.getVersionString().startsWith("${")) {
                if (PropertiesUtils.updateProperties(this.session, project, false, PropertiesUtils.extractPropertyName(parentGAV.getVersionString()), newVersion2) == PropertiesUtils.PropertyUpdate.NOTFOUND) {
                    this.logger.error("Unable to find property {} to update with version {}", (Object)parentGAV.getVersionString(), (Object)newVersion2);
                }
            } else {
                parent.setVersion(newVersion2);
            }
            changed = true;
        }
        if (model.getVersion() != null) {
            newVersion = versionsByGAV.get(gav);
            this.logger.info("Looking for new version: {} (found: {})", (Object)gav, (Object)newVersion);
            if (newVersion != null) {
                if (gav.getVersionString().startsWith("${")) {
                    if (PropertiesUtils.updateProperties(this.session, project, false, PropertiesUtils.extractPropertyName(gav.getVersionString()), newVersion) == PropertiesUtils.PropertyUpdate.NOTFOUND) {
                        this.logger.error("Unable to find property {} to update with version {}", (Object)gav.getVersionString(), (Object)newVersion);
                    }
                } else {
                    model.setVersion(newVersion);
                }
                this.logger.info("Changed main version in {}", (Object)project);
                changed = true;
            }
        } else if (!changed && project.isInheritanceRoot()) {
            newVersion = versionsByGAV.get(gav);
            this.logger.info("Looking to force inject new version for : {} (found: {})", (Object)gav, (Object)newVersion);
            if (newVersion != null) {
                model.setVersion(newVersion);
                changed = true;
            }
        }
        HashSet<ModelBase> bases = new HashSet<ModelBase>();
        bases.add(model);
        bases.addAll(ProfileUtils.getProfiles(this.session, model));
        PropertyInterpolator pi = new PropertyInterpolator(model.getProperties(), project);
        for (ModelBase base : bases) {
            String newVersion3;
            DependencyManagement dm = base.getDependencyManagement();
            if (dm != null && dm.getDependencies() != null) {
                for (Dependency d : dm.getDependencies()) {
                    if (StringUtils.isEmpty(pi.interp(d.getVersion()))) {
                        this.logger.trace("Skipping dependency {} as empty version.", (Object)d);
                        continue;
                    }
                    try {
                        gav = new SimpleProjectVersionRef(pi.interp(d.getGroupId()), pi.interp(d.getArtifactId()), pi.interp(d.getVersion()));
                        newVersion3 = versionsByGAV.get(gav);
                        if (newVersion3 == null) continue;
                        this.logger.debug("Examining dependency (from depMgmt) {} to change version to {} ", (Object)d, (Object)newVersion3);
                        if (d.getVersion().startsWith("${")) {
                            if (PropertiesUtils.updateProperties(this.session, project, false, PropertiesUtils.extractPropertyName(d.getVersion()), newVersion3) == PropertiesUtils.PropertyUpdate.NOTFOUND) {
                                this.logger.error("Unable to find property {} to update with version {}", (Object)d.getVersion(), (Object)newVersion3);
                            }
                        } else {
                            d.setVersion(newVersion3);
                            this.logger.info("Changed managed: {} in {} to {} from {}", d, base, newVersion3, gav.getVersionString());
                        }
                        changed = true;
                    }
                    catch (InvalidRefException ire) {
                        this.logger.debug("Unable to change version for dependency {} due to {} ", (Object)d.toString(), (Object)ire);
                        throw ire;
                    }
                }
            }
            if (base.getDependencies() == null) continue;
            for (Dependency d : base.getDependencies()) {
                try {
                    if (StringUtils.isEmpty(pi.interp(d.getVersion()))) {
                        this.logger.trace("Skipping dependency {} as empty version.", (Object)d);
                        continue;
                    }
                    gav = new SimpleProjectVersionRef(pi.interp(d.getGroupId()), pi.interp(d.getArtifactId()), pi.interp(d.getVersion()));
                    newVersion3 = versionsByGAV.get(gav);
                    if (newVersion3 == null || d.getVersion() == null) continue;
                    this.logger.debug("Examining dependency {} to change version to {} ", (Object)d, (Object)newVersion3);
                    if (d.getVersion().startsWith("${")) {
                        if (PropertiesUtils.updateProperties(this.session, project, false, PropertiesUtils.extractPropertyName(d.getVersion()), newVersion3) == PropertiesUtils.PropertyUpdate.NOTFOUND) {
                            this.logger.error("Unable to find property {} to update with version {}", (Object)d.getVersion(), (Object)newVersion3);
                        }
                    } else {
                        d.setVersion(newVersion3);
                        this.logger.info("Changed: {} in {} to {} from {}", d, base, newVersion3, gav.getVersionString());
                    }
                    changed = true;
                }
                catch (InvalidRefException ire) {
                    this.logger.debug("Unable to change version for dependency {} due to {} ", (Object)d.toString(), (Object)ire);
                    throw ire;
                }
            }
        }
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return 20;
    }
}

