/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.SuffixState;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="suffix-manipulator")
@Singleton
public class SuffixManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new SuffixState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        SuffixState state = this.session.getState(SuffixState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Pattern suffixStripPattern = Pattern.compile(state.getSuffixStrip());
        for (Project project : projects) {
            Matcher m;
            Parent parent = project.getModel().getParent();
            if (parent != null && parent.getVersion() != null && (m = suffixStripPattern.matcher(parent.getVersion())).matches()) {
                this.logger.info("Stripping suffix for {} and resetting parent version from {} to {}", project.getKey(), parent.getVersion(), m.group(1));
                parent.setVersion(m.group(1));
                changed.add(project);
            }
            if (project.getModel().getVersion() != null && (m = suffixStripPattern.matcher(project.getModel().getVersion())).matches()) {
                this.logger.info("Stripping suffix and resetting project version from {} to {}", (Object)project.getModel().getVersion(), (Object)m.group(1));
                project.getModel().setVersion(m.group(1));
                changed.add(project);
            }
            this.processDependencies(suffixStripPattern, project, project.getResolvedDependencies(this.session));
            this.processDependencies(suffixStripPattern, project, project.getResolvedManagedDependencies(this.session));
            this.processPlugins(suffixStripPattern, project, project.getResolvedPlugins(this.session));
            this.processPlugins(suffixStripPattern, project, project.getResolvedManagedPlugins(this.session));
            List<Profile> profiles = ProfileUtils.getProfiles(this.session, project.getModel());
            for (Profile p : profiles) {
                this.processDependencies(suffixStripPattern, project, project.getResolvedProfileDependencies(this.session).get(p));
                this.processDependencies(suffixStripPattern, project, project.getResolvedProfileManagedDependencies(this.session).get(p));
                this.processPlugins(suffixStripPattern, project, project.getResolvedProfilePlugins(this.session).get(p));
                this.processPlugins(suffixStripPattern, project, project.getResolvedProfileManagedPlugins(this.session).get(p));
            }
        }
        return changed;
    }

    private void processPlugins(Pattern suffixStripPattern, Project project, Map<ProjectVersionRef, Plugin> plugins) throws ManipulationException {
        try {
            if (plugins != null) {
                plugins.keySet().forEach(a -> {
                    Plugin original = (Plugin)plugins.get(a);
                    Matcher m = suffixStripPattern.matcher(a.getVersionString());
                    if (m.matches()) {
                        String stripped = m.group(1);
                        this.logger.info("Stripping suffix from plugin {} (version {}) to {} ", a, original.getVersion(), stripped);
                        if (original.getVersion().contains("$")) {
                            this.handleProperties(project, original.getVersion(), stripped);
                        } else {
                            original.setVersion(stripped);
                        }
                    }
                });
            }
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private void processDependencies(Pattern suffixStripPattern, Project project, Map<ArtifactRef, Dependency> deps) throws ManipulationException {
        try {
            if (deps != null) {
                deps.keySet().forEach(a -> {
                    Dependency original = (Dependency)deps.get(a);
                    Matcher m = suffixStripPattern.matcher(a.getVersionString());
                    if (m.matches()) {
                        String stripped = m.group(1);
                        this.logger.info("Stripping suffix from dependency {} (version {}) to {} ", a, original.getVersion(), stripped);
                        if (original.getVersion().contains("$")) {
                            this.handleProperties(project, original.getVersion(), stripped);
                        } else {
                            original.setVersion(stripped);
                        }
                    }
                });
            }
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private void handleProperties(Project project, String original, String stripped) {
        try {
            PropertiesUtils.updateProperties(this.session, project, true, PropertiesUtils.extractPropertyName(original), stripped);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 6;
    }
}

