/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.ManipulationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JSONIO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();
    private Configuration conf = Configuration.builder().options(Option.ALWAYS_RETURN_LIST).build();
    private PrettyPrinter dpp = new MyPrettyPrinter();

    public DocumentContext parseJSON(File jsonFile) throws ManipulationException {
        DocumentContext doc;
        if (jsonFile == null || !jsonFile.exists()) {
            throw new ManipulationException("JSON File not found", new String[0]);
        }
        try {
            doc = JsonPath.using(this.conf).parse(jsonFile);
        }
        catch (IOException e) {
            this.logger.error("Unable to parse JSON File {} ", e);
            throw new ManipulationException("Unable to parse JSON File", (Throwable)e, new Object[0]);
        }
        return doc;
    }

    public void writeJSON(File target, String contents) throws ManipulationException {
        try {
            String pretty = this.mapper.writer(this.dpp).writeValueAsString(this.mapper.readValue(contents, Object.class));
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            try (OutputStreamWriter p = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                p.write(pretty);
                p.append('\n');
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to write JSON string:  ", e);
            throw new ManipulationException("Unable to write JSON string", (Throwable)e, new Object[0]);
        }
    }

    private class MyPrettyPrinter
    extends DefaultPrettyPrinter {
        public MyPrettyPrinter() {
            super(DEFAULT_ROOT_VALUE_SEPARATOR);
        }

        public MyPrettyPrinter(MyPrettyPrinter base) {
            super(base, base._rootSeparator);
        }

        @Override
        public DefaultPrettyPrinter createInstance() {
            return new MyPrettyPrinter(this);
        }

        @Override
        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            if (this._spacesInObjectEntries) {
                jg.writeRaw(": ");
            } else {
                jg.writeRaw(':');
            }
        }
    }
}

