/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.rest.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.io.rest.Translator;
import org.commonjava.maven.ext.io.rest.exception.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListingBlacklistMapper
implements com.mashape.unirest.http.ObjectMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String errorString;
    private Translator.RestProtocol protocol;

    public ListingBlacklistMapper(Translator.RestProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public Object readValue(String s) {
        List responseBody;
        ArrayList<SimpleProjectVersionRef> result = new ArrayList<SimpleProjectVersionRef>();
        if (s.length() == 0) {
            this.errorString = "No content to read.";
            return result;
        }
        if (s.startsWith("<")) {
            String stripped = s.replaceFirst(".*</h1>\n", "").replaceFirst("\n</body></html>", "");
            this.logger.debug("Read HTML string '{}' rather than a JSON stream; stripping message to {}", (Object)s, (Object)stripped);
            this.errorString = stripped;
            return result;
        }
        if (s.startsWith("{\\\"message\\\":") || s.startsWith("{\"message\":")) {
            String endStripped = s.replace("\\\"}", "").replace("\"}", "");
            this.errorString = endStripped.substring(endStripped.lastIndexOf("\"") + 1);
            this.logger.debug("Read message string {}, processed to {} ", (Object)s, (Object)this.errorString);
            return result;
        }
        try {
            responseBody = this.objectMapper.readValue(s, List.class);
        }
        catch (IOException e) {
            this.logger.error("Failed to decode map when reading string {}", (Object)s);
            throw new RestException("Failed to read list-of-maps response from version server: " + e.getMessage(), e);
        }
        for (Map gav : responseBody) {
            String groupId = (String)gav.get("groupId");
            String artifactId = (String)gav.get("artifactId");
            String version = (String)gav.get("version");
            SimpleProjectVersionRef project = new SimpleProjectVersionRef(groupId, artifactId, version);
            result.add(project);
        }
        return result;
    }

    @Override
    public String writeValue(Object value) {
        throw new RestException("Fatal: Should not be overriding writeObject for ListingBlacklistMapper");
    }

    public String getErrorString() {
        return this.errorString;
    }
}

