/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.filearc.internal.AbstractZipOperation;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.spi.transport.PublishJob;

public class ZipPublish
extends AbstractZipOperation
implements PublishJob {
    private final InputStream stream;
    private TransferException error;
    private boolean success;

    public ZipPublish(ConcreteResource resource, InputStream stream) {
        super(resource);
        this.stream = stream;
    }

    @Override
    public long getTransferSize() {
        return -1L;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    @Override
    public ZipPublish call() {
        String path = this.getFullPath();
        File dest = this.getZipFile();
        this.success = dest.exists() ? this.rewriteArchive(dest, path).booleanValue() : this.writeArchive(dest, path).booleanValue();
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean writeArchive(File dest, String path) {
        Boolean bl;
        boolean isJar = this.isJarOperation();
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        ZipFile zf = null;
        try {
            fos = new FileOutputStream(dest);
            zos = isJar ? new JarOutputStream(fos) : new ZipOutputStream(fos);
            zf = isJar ? new JarFile(dest) : new ZipFile(dest);
            ZipEntry entry = zf.getEntry(path);
            zos.putNextEntry(entry);
            IOUtils.copy(this.stream, (OutputStream)zos);
            bl = true;
        }
        catch (IOException e) {
            try {
                this.error = new TransferException("Failed to write path: %s to NEW archive: %s. Reason: %s", (Throwable)e, path, dest, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly(fos);
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly(this.stream);
                throw throwable;
            }
            IOUtils.closeQuietly(zos);
            IOUtils.closeQuietly(fos);
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly(this.stream);
            return false;
        }
        IOUtils.closeQuietly(zos);
        IOUtils.closeQuietly(fos);
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly(this.stream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean rewriteArchive(File dest, String path) {
        Object en;
        boolean isJar = this.isJarOperation();
        File src = new File(dest.getParentFile(), dest.getName() + ".old");
        dest.renameTo(src);
        InputStream zin = null;
        ZipFile zfIn = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        ZipFile zfOut = null;
        try {
            fos = new FileOutputStream(dest);
            zos = isJar ? new JarOutputStream(fos) : new ZipOutputStream(fos);
            zfOut = isJar ? new JarFile(dest) : new ZipFile(dest);
            zfIn = isJar ? new JarFile(src) : new ZipFile(src);
            en = zfIn.entries();
            while (en.hasMoreElements()) {
                ZipEntry inEntry = en.nextElement();
                String inPath = inEntry.getName();
                try {
                    zin = inPath.equals(path) ? this.stream : zfIn.getInputStream(inEntry);
                    ZipEntry entry = zfOut.getEntry(inPath);
                    zos.putNextEntry(entry);
                    IOUtils.copy(this.stream, (OutputStream)zos);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zin);
                    throw throwable;
                }
                IOUtils.closeQuietly(zin);
            }
            en = true;
        }
        catch (IOException e) {
            try {
                this.error = new TransferException("Failed to write path: %s to EXISTING archive: %s. Reason: %s", (Throwable)e, path, dest, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly(fos);
                if (zfOut != null) {
                    try {
                        zfOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (zfIn != null) {
                    try {
                        zfIn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly(this.stream);
                throw throwable;
            }
            IOUtils.closeQuietly(zos);
            IOUtils.closeQuietly(fos);
            if (zfOut != null) {
                try {
                    zfOut.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (zfIn != null) {
                try {
                    zfIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly(this.stream);
            return false;
        }
        IOUtils.closeQuietly(zos);
        IOUtils.closeQuietly(fos);
        if (zfOut != null) {
            try {
                zfOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (zfIn != null) {
            try {
                zfIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly(this.stream);
        return en;
    }
}

