/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.io.AbstractTransferDecorator;
import org.commonjava.maven.galley.io.nocache.NoCacheInputStream;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Named
public class NoCacheTransferDecorator
extends AbstractTransferDecorator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SpecialPathManager specialPathManager;

    public NoCacheTransferDecorator(SpecialPathManager specialPathManager) {
        this.specialPathManager = specialPathManager;
    }

    @Override
    public InputStream decorateRead(InputStream stream, Transfer transfer, EventMetadata eventMetadata) throws IOException {
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(transfer, eventMetadata.getPackageType());
        this.logger.trace("SpecialPathInfo for: {} is: {} (cachable? {})", transfer, specialPathInfo, specialPathInfo == null || specialPathInfo.isCachable());
        if (specialPathInfo != null && !specialPathInfo.isCachable()) {
            this.logger.trace("Decorating read with NoCacheTransferDecorator for: {}", (Object)transfer);
            return new NoCacheInputStream(stream, transfer);
        }
        return stream;
    }
}

