/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.io.OverriddenBooleanValue;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Named
public class TransferDecoratorPipeline
implements TransferDecorator {
    private List<TransferDecorator> decorators;

    public TransferDecoratorPipeline(List<TransferDecorator> decorators) {
        this.decorators = decorators;
    }

    public TransferDecoratorPipeline(TransferDecorator ... decorators) {
        this.decorators = Arrays.asList(decorators);
    }

    @Override
    public OutputStream decorateWrite(OutputStream stream, Transfer transfer, TransferOperation op, EventMetadata metadata) throws IOException {
        OutputStream result = stream;
        for (TransferDecorator decorator : this.decorators) {
            result = decorator.decorateWrite(result, transfer, op, metadata);
        }
        return result;
    }

    @Override
    public InputStream decorateRead(InputStream stream, Transfer transfer, EventMetadata metadata) throws IOException {
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        InputStream result = stream;
        for (TransferDecorator decorator : this.decorators) {
            logger2.debug("Decorating: {} using decorator: {}", (Object)result.getClass().getName(), (Object)decorator.getClass().getName());
            result = decorator.decorateRead(result, transfer, metadata);
        }
        logger2.debug("Returning: {}", (Object)result.getClass().getName());
        return result;
    }

    @Override
    public void decorateTouch(Transfer transfer, EventMetadata metadata) {
        for (TransferDecorator decorator : this.decorators) {
            decorator.decorateTouch(transfer, metadata);
        }
    }

    @Override
    public OverriddenBooleanValue decorateExists(Transfer transfer, EventMetadata metadata) {
        OverriddenBooleanValue result = OverriddenBooleanValue.DEFER;
        for (TransferDecorator decorator : this.decorators) {
            result = decorator.decorateExists(transfer, metadata);
            if (!result.overrides()) continue;
            return result;
        }
        return result;
    }

    @Override
    public void decorateCopyFrom(Transfer from, Transfer transfer, EventMetadata metadata) throws IOException {
        for (TransferDecorator decorator : this.decorators) {
            decorator.decorateCopyFrom(from, transfer, metadata);
        }
    }

    @Override
    public void decorateDelete(Transfer transfer, EventMetadata metadata) throws IOException {
        for (TransferDecorator decorator : this.decorators) {
            decorator.decorateDelete(transfer, metadata);
        }
    }

    @Override
    public String[] decorateListing(Transfer transfer, String[] listing, EventMetadata metadata) throws IOException {
        String[] result = listing;
        for (TransferDecorator decorator : this.decorators) {
            result = decorator.decorateListing(transfer, listing, metadata);
        }
        return result;
    }

    @Override
    public void decorateMkdirs(Transfer transfer, EventMetadata metadata) throws IOException {
        for (TransferDecorator decorator : this.decorators) {
            decorator.decorateMkdirs(transfer, metadata);
        }
    }

    @Override
    public void decorateCreateFile(Transfer transfer, EventMetadata metadata) throws IOException {
        for (TransferDecorator decorator : this.decorators) {
            decorator.decorateCreateFile(transfer, metadata);
        }
    }
}

