/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.commonjava.maven.galley.maven.model.view.MavenXmlView;
import org.commonjava.maven.galley.maven.parse.JXPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMavenElementView<T extends MavenXmlView<?>> {
    protected final Element element;
    protected Element collapsed;
    protected final JXPathContext elementContext;
    protected JXPathContext collapsedElementContext;
    protected final T xmlView;
    protected ArrayList<Element> elementsAwaitingCollapse;
    protected ArrayList<Element> elements;

    public AbstractMavenElementView(T xmlView, Element element) {
        this.xmlView = xmlView;
        this.element = element;
        this.elementContext = JXPathUtils.newContext(element);
        this.collapsed = element;
        this.collapsedElementContext = this.elementContext;
    }

    public final Element getElement() {
        return this.element;
    }

    public Element getCollapsedElement() {
        if (this.isElementStackEmpty(this.elementsAwaitingCollapse)) {
            return this.collapsed;
        }
        this.addElementToStack(this.elementsAwaitingCollapse);
        String textContent = this.getFirstValueInOverlappingElements(this.collapsed, this.elementsAwaitingCollapse);
        if (null != textContent) {
            this.collapsed.setTextContent(textContent);
        } else {
            NodeList nodeList = this.collapsed.getChildNodes();
            for (int i = 0; i <= nodeList.getLength(); ++i) {
                String childText;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || null == (childText = this.getFirstValueInOverlappingElements(node, this.elementsAwaitingCollapse))) continue;
                node.setTextContent(childText);
            }
            this.addToCollapsedChildElements(this.collapsed, 0);
        }
        this.elementsAwaitingCollapse.clear();
        this.collapsedElementContext = JXPathUtils.newContext(this.collapsed);
        return this.collapsed;
    }

    public final T getXmlView() {
        return this.xmlView;
    }

    public final String toXML() {
        return ((MavenXmlView)this.xmlView).toXML(this.element);
    }

    protected JXPathContext getCollapsedElementContext() {
        this.getCollapsedElement();
        return this.collapsedElementContext;
    }

    protected String getValue(String path) {
        Node node = ((MavenXmlView)this.xmlView).resolveXPathToNodeFrom(this.getCollapsedElementContext(), path, false);
        if (node == null) {
            return null;
        }
        String reTextContent = this.getFirstValueInOverlappingElements(node, this.elements);
        if (null != reTextContent) {
            return reTextContent;
        }
        return node.getTextContent().trim();
    }

    protected final Element getElement(String path) {
        if (path.contains("/")) {
            return (Element)this.getNode(path);
        }
        NodeList nl = this.getCollapsedElement().getElementsByTagName(path);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    protected final List<Element> getElements(String path) {
        if (path.contains("/")) {
            List<Node> nodes = this.getNodes(path);
            if (nodes != null) {
                ArrayList<Element> elements = new ArrayList<Element>();
                for (Node node : nodes) {
                    elements.add((Element)node);
                }
                return elements;
            }
        } else {
            NodeList nl = this.getCollapsedElement().getChildNodes();
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (!"*".equals(path) && !e.getTagName().equals(path)) continue;
                elements.add((Element)node);
            }
            return elements;
        }
        return null;
    }

    protected final Node getNode(String path) {
        Node node = (Node)this.getCollapsedElementContext().selectSingleNode(path);
        String textContent = this.getFirstValueInOverlappingElements(node, this.elements);
        if (textContent != null) {
            node.setTextContent(textContent);
        }
        return node;
    }

    protected final List<Node> getNodes(String path) {
        List nodes = this.getCollapsedElementContext().selectNodes(path);
        for (Node node : nodes) {
            String textContent = this.getFirstValueInOverlappingElements(node, this.elements);
            if (textContent == null) continue;
            node.setTextContent(textContent);
        }
        return nodes;
    }

    protected void addOverlappingElements(AbstractMavenElementView other) {
        if (this.isElementStackEmpty(this.elements)) {
            this.elements = new ArrayList();
        }
        this.addElement(other.getCollapsedElement());
    }

    private void addElement(Element other) {
        if (this.isElementStackEmpty(this.elementsAwaitingCollapse)) {
            this.elementsAwaitingCollapse = new ArrayList();
        }
        this.elementsAwaitingCollapse.add(other);
    }

    private String getFirstValueInOverlappingElements(Node child, List<Element> overlappingElements) {
        if (null == child || this.isElementStackEmpty(overlappingElements)) {
            return null;
        }
        String childName = child.getNodeName();
        String childTextContent = child.getTextContent();
        for (Element e : overlappingElements) {
            NodeList nodeList = e.getChildNodes();
            for (int i = 0; i <= nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                String textContent = node.getTextContent().trim();
                if (!node.getNodeName().equals(childName) || !childTextContent.isEmpty() || textContent.isEmpty()) continue;
                return textContent;
            }
        }
        return null;
    }

    private Element addToCollapsedChildElements(Element current, int step) {
        ArrayList<Element> parents = this.elementsAwaitingCollapse;
        while (!this.isElementStackEmpty(parents) && step < parents.size()) {
            NodeList originalElementChildNodeList = current.getChildNodes();
            ArrayList<String> originalElementChildNameList = new ArrayList<String>();
            for (int i = 0; i <= originalElementChildNodeList.getLength(); ++i) {
                Node node = originalElementChildNodeList.item(i);
                if (!(node instanceof Element)) continue;
                originalElementChildNameList.add(node.getNodeName());
            }
            NodeList nodeList = ((Element)parents.get(step)).getChildNodes();
            for (int i = 0; i <= nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || originalElementChildNameList.contains(node.getNodeName())) continue;
                Document dom = current.getOwnerDocument();
                Element child = dom.createElement(node.getNodeName());
                child.setTextContent(node.getTextContent());
                current.appendChild(child);
            }
            this.addToCollapsedChildElements(current, ++step);
        }
        return current;
    }

    private void addElementToStack(List<Element> elementsAwaiting) {
        this.elements.addAll(elementsAwaiting);
    }

    private boolean isElementStackEmpty(List<Element> elements) {
        return null == elements || elements.isEmpty();
    }
}

