/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.io.File;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.model.view.settings.MavenSettingsView;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.w3c.dom.Document;

@ApplicationScoped
public class MavenSettingsReader {
    @Inject
    private XPathManager xpath;
    @Inject
    private XMLInfrastructure xml;

    protected MavenSettingsReader() {
    }

    public MavenSettingsReader(XMLInfrastructure xml, XPathManager xpath) {
        this.xml = xml;
        this.xpath = xpath;
    }

    public MavenSettingsView read(File ... settingsFiles) throws GalleyMavenException {
        ArrayList<DocRef<File>> drs = new ArrayList<DocRef<File>>();
        for (File f : settingsFiles) {
            if (f == null || !f.exists()) continue;
            try {
                Document doc = this.xml.parse(f);
                drs.add(new DocRef<File>(f, f, doc));
            }
            catch (GalleyMavenXMLException e) {
                throw new GalleyMavenException("Failed to parse settings XML: {}. Reason: {}", (Throwable)e, f, e.getMessage());
            }
        }
        if (drs.isEmpty()) {
            return null;
        }
        return new MavenSettingsView(drs, this.xpath, this.xml);
    }
}

