/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpGet;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.AbstractHttpJob;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListing
extends AbstractHttpJob
implements ListingJob {
    private static final Set<String> EXCLUDES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("../");
        }
    };
    private final ConcreteResource resource;

    public HttpListing(String url, ConcreteResource resource, Http http) {
        super(url, (HttpLocation)resource.getLocation(), http, new Integer[0]);
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ListingResult call() {
        InputStream in;
        ListingResult result;
        block7: {
            this.request = new HttpGet(this.url);
            result = null;
            in = null;
            try {
                if (!this.executeHttp()) break block7;
                in = this.response.getEntity().getContent();
                String listing = IOUtils.toString(in);
                Logger logger2 = LoggerFactory.getLogger(this.getClass());
                logger2.debug("Got raw listing content:\n\n{}\n\n", (Object)listing);
                ArrayList<String> al = new ArrayList<String>();
                Document doc = Jsoup.parse(listing, this.url);
                if (doc == null) break block7;
                for (Element link : doc.select("a")) {
                    String linkText = link.text();
                    String linkHref = link.attr("href");
                    URL url = new URL(this.url);
                    boolean sameServer = HttpListing.isSameServer(url, linkHref);
                    boolean subpath = HttpListing.isSubpath(url, linkHref);
                    if (!sameServer || !subpath || !linkHref.endsWith(linkText) && !linkHref.endsWith(linkText + '/') || EXCLUDES.contains(linkText)) continue;
                    al.add(linkText);
                }
                result = new ListingResult(this.resource, al.toArray(new String[al.size()]));
            }
            catch (TransferException e) {
                this.error = e;
                IOUtils.closeQuietly(in);
                this.cleanup();
            }
            catch (IOException e2) {
                this.error = new TransferException("Failed to construct directory listing for: {}. Reason: {}", (Throwable)e2, this.url, e2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        this.cleanup();
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(in);
                this.cleanup();
            }
        }
        IOUtils.closeQuietly(in);
        this.cleanup();
        return this.error == null ? result : null;
    }

    static boolean isSubpath(URL url, String linkHref) {
        String linkPath;
        try {
            URL linkUrl = new URL(linkHref);
            linkPath = linkUrl.getPath();
        }
        catch (MalformedURLException ex) {
            linkPath = linkHref;
        }
        boolean valid = linkPath.length() > 0 && (linkPath.charAt(0) != '/' && linkPath.charAt(0) != '.' || linkPath.startsWith(url.getPath()));
        Logger logger2 = LoggerFactory.getLogger(HttpListing.class);
        logger2.debug("Does URL: {} (linkPath: {}) reference a sub-path of: {}? {}", linkHref, linkPath, url.getPath(), valid);
        return valid;
    }

    static boolean isSameServer(URL url, String linkHref) {
        String linkProtocol = null;
        String linkAuthority = null;
        Logger logger2 = LoggerFactory.getLogger(HttpListing.class);
        try {
            URL linkUrl = new URL(linkHref);
            linkProtocol = linkUrl.getProtocol();
            linkAuthority = linkUrl.getAuthority();
            logger2.debug("Absolute URL: {} is on the same server.", (Object)linkHref);
        }
        catch (MalformedURLException ex) {
            logger2.debug("URL is relative, must be on the same server.");
        }
        boolean valid = !(linkProtocol != null && !linkProtocol.equals(url.getProtocol()) || linkAuthority != null && !linkAuthority.equals(url.getAuthority()));
        logger2.debug("URL: {} has same protocol and authority? {}", (Object)linkHref, (Object)valid);
        return valid;
    }
}

