/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.auth;

import java.util.HashMap;
import java.util.Map;
import org.commonjava.util.jhttpc.auth.PasswordKey;
import org.commonjava.util.jhttpc.auth.PasswordManager;
import org.commonjava.util.jhttpc.auth.PasswordType;
import org.commonjava.util.jhttpc.model.SiteConfig;

public class MemoryPasswordManager
implements PasswordManager {
    private final Map<PasswordKey, String> passwords = new HashMap<PasswordKey, String>();

    @Override
    public void bind(String password, SiteConfig config, PasswordType type) {
        this.passwords.put(new PasswordKey(config.getId(), type), password);
    }

    @Override
    public void bind(String password, String siteId, PasswordType type) {
        this.passwords.put(new PasswordKey(siteId, type), password);
    }

    @Override
    public void bind(String password, PasswordKey id) {
        this.passwords.put(id, password);
    }

    @Override
    public void unbind(SiteConfig config, PasswordType type) {
        this.passwords.remove(new PasswordKey(config.getId(), type));
    }

    @Override
    public void unbind(String siteId, PasswordType type) {
        this.passwords.remove(new PasswordKey(siteId, type));
    }

    @Override
    public void unbind(PasswordKey id) {
        this.passwords.remove(id);
    }

    @Override
    public String lookup(PasswordKey id) {
        return this.passwords.get(id);
    }
}

