/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String stringQueryParameter(Object value) {
        String base = String.valueOf(value);
        return "%22" + base + "%22";
    }

    public static String buildUrl(String baseUrl, String ... parts) throws MalformedURLException {
        return UrlUtils.buildUrl(baseUrl, null, parts);
    }

    public static String buildUrl(String baseUrl, Map<String, String> params, String ... parts) throws MalformedURLException {
        if (!(params != null && !params.isEmpty() || parts != null && parts.length >= 1)) {
            return baseUrl;
        }
        StringBuilder urlBuilder = new StringBuilder();
        if (parts == null || parts.length < 1 || parts[0] == null || !parts[0].startsWith(baseUrl)) {
            urlBuilder.append(baseUrl);
        }
        for (String part : parts) {
            if (part == null || part.trim().length() < 1) continue;
            if (part.startsWith("/")) {
                part = part.substring(1);
            }
            if (urlBuilder.length() > 0 && urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                urlBuilder.append("/");
            }
            urlBuilder.append(part);
        }
        if (params != null && !params.isEmpty()) {
            urlBuilder.append("?");
            boolean first = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    urlBuilder.append("&");
                }
                urlBuilder.append(param.getKey()).append("=").append(param.getValue());
            }
        }
        return new URL(urlBuilder.toString()).toExternalForm();
    }
}

