/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.core.aggregation.ComponentUpgradeAggregator;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.UpgradeProcessingStrategy;

public class TextReportProcessingStrategy
implements UpgradeProcessingStrategy {
    protected static final Logger LOG = Logger.getLogger(TextReportProcessingStrategy.class);
    protected static final String PROJECT_URL = "https://github.com/jboss-set/maven-dependency-updater";
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss z yyyy-MM-dd");
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    protected final File pomFile;
    protected final Configuration configuration;
    protected PrintStream outputStream;
    protected File outputFile;

    public TextReportProcessingStrategy(Configuration configuration, File pomFile) {
        this.configuration = configuration;
        this.pomFile = pomFile;
    }

    public TextReportProcessingStrategy(Configuration configuration, File pomFile, String outputFileName) {
        this(configuration, pomFile);
        this.outputFile = new File(outputFileName);
    }

    public TextReportProcessingStrategy(Configuration configuration, File pomFile, PrintStream outputStream) {
        this(configuration, pomFile);
        this.outputStream = outputStream;
    }

    protected void initOutputStream() {
        try {
            if (this.outputStream == null) {
                this.outputStream = this.outputFile == null ? System.out : new PrintStream(this.outputFile);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't create output stream", e);
        }
    }

    @Override
    public boolean process(List<DependencyEvaluator.ComponentUpgrade> upgrades) throws Exception {
        try {
            if (upgrades.size() == 0) {
                LOG.info("No components to upgrade.");
                boolean bl = true;
                return bl;
            }
            this.initOutputStream();
            List<DependencyEvaluator.ComponentUpgrade> sortedUpgrades = upgrades.stream().sorted(new ComponentUpgradeComparator()).collect(Collectors.toList());
            List<DependencyEvaluator.ComponentUpgrade> aggregatedUpgrades = ComponentUpgradeAggregator.aggregateComponentUpgrades(this.pomFile, sortedUpgrades);
            this.outputStream.println("Generated at " + DATE_TIME_FORMATTER.format(ZonedDateTime.now()));
            this.outputStream.println();
            this.outputStream.println("Searched in following repositories:\n");
            for (Map.Entry<String, String> entry : this.configuration.getRepositories().entrySet()) {
                this.outputStream.println("* " + entry.getKey() + ": " + entry.getValue());
            }
            this.outputStream.println();
            this.outputStream.println("Possible upgrades:\n");
            for (DependencyEvaluator.ComponentUpgrade upgrade : aggregatedUpgrades) {
                ArtifactRef artifact = upgrade.getArtifact();
                this.outputStream.println(String.format("%s:%s:%s -> %s (%s) - %s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionString(), upgrade.getNewVersion(), upgrade.getRepository(), upgrade.getFirstSeen() == null ? "new" : "since " + upgrade.getFirstSeen().format(DATE_FORMATTER)));
            }
            this.outputStream.println("\n" + aggregatedUpgrades.size() + " items");
            this.outputStream.println("\nReport generated by Maven Dependency Updater");
            this.outputStream.println(PROJECT_URL);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("Report generation failed", e);
        }
        finally {
            if (this.outputStream != null && this.outputStream != System.out) {
                this.outputStream.close();
            }
        }
    }

    protected static class ComponentUpgradeComparator
    implements Comparator<DependencyEvaluator.ComponentUpgrade> {
        protected ComponentUpgradeComparator() {
        }

        @Override
        public int compare(DependencyEvaluator.ComponentUpgrade o1, DependencyEvaluator.ComponentUpgrade o2) {
            if (o1.getFirstSeen() == null && o2.getFirstSeen() == null) {
                return o1.getArtifact().compareTo(o2.getArtifact());
            }
            if (o1.getFirstSeen() == null) {
                return -1;
            }
            if (o2.getFirstSeen() == null) {
                return 1;
            }
            int res = -o1.getFirstSeen().toLocalDate().compareTo(o2.getFirstSeen().toLocalDate());
            if (res == 0) {
                res = o1.getArtifact().toString().compareTo(o2.getArtifact().toString());
            }
            return res;
        }
    }
}

