/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public final class GHContentBuilder {
    private final GHRepository repo;
    private final Requester req;
    private String path;

    GHContentBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = new Requester(repo.root).method("PUT");
    }

    public GHContentBuilder path(String path) {
        this.path = path;
        this.req.with("path", path);
        return this;
    }

    public GHContentBuilder branch(String branch) {
        this.req.with("branch", branch);
        return this;
    }

    public GHContentBuilder sha(String sha) {
        this.req.with("sha", sha);
        return this;
    }

    public GHContentBuilder content(byte[] content) {
        this.req.with("content", Base64.encodeBase64String(content));
        return this;
    }

    public GHContentBuilder content(String content) {
        try {
            return this.content(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException x) {
            throw new AssertionError();
        }
    }

    public GHContentBuilder message(String commitMessage) {
        this.req.with("message", commitMessage);
        return this;
    }

    public GHContentUpdateResponse commit() throws IOException {
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)this.req.to(this.repo.getApiTailUrl("contents/" + this.path), GHContentUpdateResponse.class));
        response.getContent().wrap(this.repo);
        response.getCommit().wrapUp(this.repo);
        return response;
    }
}

