/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHPullRequestReviewEvent;
import org.kohsuke.github.GHPullRequestReviewState;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHPullRequestReview
extends GHObject {
    GHPullRequest owner;
    private String body;
    private GHUser user;
    private String commit_id;
    private GHPullRequestReviewState state;

    GHPullRequestReview wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.getLogin());
    }

    public String getCommitId() {
        return this.commit_id;
    }

    @CheckForNull
    public GHPullRequestReviewState getState() {
        return this.state;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    protected String getApiRoute() {
        return this.owner.getApiRoute() + "/reviews/" + this.id;
    }

    public void submit(String body, GHPullRequestReviewState state) throws IOException {
        this.submit(body, state.toEvent());
    }

    public void submit(String body, GHPullRequestReviewEvent event) throws IOException {
        new Requester(this.owner.root).method("POST").with("body", body).with("event", event.action()).to(this.getApiRoute() + "/events", this);
        this.body = body;
        this.state = event.toState();
    }

    public void delete() throws IOException {
        new Requester(this.owner.root).method("DELETE").to(this.getApiRoute());
    }

    public void dismiss(String message) throws IOException {
        new Requester(this.owner.root).method("PUT").with("message", message).to(this.getApiRoute() + "/dismissals");
        this.state = GHPullRequestReviewState.DISMISSED;
    }

    public PagedIterable<GHPullRequestReviewComment> listReviewComments() throws IOException {
        return new PagedIterable<GHPullRequestReviewComment>(){

            @Override
            public PagedIterator<GHPullRequestReviewComment> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequestReviewComment>(GHPullRequestReview.this.owner.root.retrieve().asIterator(GHPullRequestReview.this.getApiRoute() + "/comments", GHPullRequestReviewComment[].class, pageSize)){

                    protected void wrapUp(GHPullRequestReviewComment[] page) {
                        for (GHPullRequestReviewComment c : page) {
                            c.wrapUp(GHPullRequestReview.this.owner);
                        }
                    }
                };
            }
        };
    }
}

