/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.jboss.set.mavendependencyupdater.AvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.DefaultAvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.projectparser.PmeDependencyCollector;

public abstract class AbstractUpdaterMojo
extends AbstractMojo {
    private static final String CONFIGURATION_FILE = "dependency-upgrades-config.json";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    protected Configuration configuration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initConfig();
        File pomFile = this.project.getModel().getPomFile();
        try {
            Collection rootProjectDependencies = new PmeDependencyCollector(pomFile).getRootProjectDependencies();
            DefaultAvailableVersionsResolver availableVersionsResolver = new DefaultAvailableVersionsResolver(this.configuration);
            DependencyEvaluator evaluator = new DependencyEvaluator(this.configuration, (AvailableVersionsResolver)availableVersionsResolver);
            List componentUpgrades = evaluator.getVersionsToUpgrade(rootProjectDependencies);
            if (componentUpgrades.size() > 0) {
                this.getLog().info((CharSequence)("Found upgradeable dependencies for project " + this.project.getName() + ": "));
                for (DependencyEvaluator.ComponentUpgrade upgrade : componentUpgrades) {
                    this.getLog().info((CharSequence)("  " + upgrade.toString()));
                }
                this.processComponentUpgrades(pomFile, componentUpgrades);
            } else {
                this.getLog().info((CharSequence)("No upgradeable dependencies found for project " + this.project.getName()));
            }
        }
        catch (ManipulationException e) {
            throw new MojoExecutionException("Problem when collecting project dependencies.", (Exception)((Object)e));
        }
    }

    protected abstract void processComponentUpgrades(File var1, List<DependencyEvaluator.ComponentUpgrade> var2) throws MojoExecutionException;

    private void initConfig() throws MojoExecutionException {
        try {
            File executionProjectDirectory = this.project.getExecutionProject().getModel().getProjectDirectory();
            File configurationFile = new File(executionProjectDirectory, CONFIGURATION_FILE);
            if (configurationFile.exists()) {
                this.getLog().info((CharSequence)("Using configuration file " + configurationFile.getPath()));
                this.configuration = new Configuration(configurationFile);
            } else {
                this.getLog().info((CharSequence)"No configuration file detected.");
                this.configuration = new Configuration(null);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read dependency updater configuration", (Exception)e);
        }
    }
}

