/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.RepositoryType;

public class StreamComponent {
    private final String name;
    private final List<String> contacts;
    private final RepositoryType repositoryType;
    private final URI repositoryURL;
    private final Codebase codebase;
    private final String tag;
    private final String version;
    private final String gav;
    private final String comment;

    public StreamComponent(String name, List<String> contacts, RepositoryType repositoryType, URI repositoryURL, Codebase codebase, String tag, String version, String gav, String comment) {
        this.name = name.toLowerCase();
        this.contacts = contacts;
        this.repositoryType = repositoryType;
        this.repositoryURL = repositoryURL;
        this.codebase = codebase;
        this.tag = tag;
        this.version = version;
        this.gav = gav;
        this.comment = comment;
    }

    public StreamComponent(String name, List<String> contacts, URI repositoryURL, Codebase codebase, String tag, String version, String gav, String comment) {
        this(name, contacts, RepositoryType.fromRepositoryURI(repositoryURL), repositoryURL, codebase, tag, version, gav, comment);
    }

    public StreamComponent(String name, List<String> contacts, URI repositoryURL, Codebase codebase, String tag, String version, String gav) {
        this(name, contacts, repositoryURL, codebase, tag, version, gav, null);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public URI getRepositoryURL() {
        return this.repositoryURL;
    }

    public Codebase getCodebase() {
        return this.codebase;
    }

    public String getTag() {
        return this.tag;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGAV() {
        return this.gav;
    }

    public String getComment() {
        return this.comment;
    }

    public Optional<String> getCodeBasePath() {
        String url = this.repositoryURL.toString();
        if (url.contains("github.com")) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return Optional.of(url + "tree/" + this.codebase.getName());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamComponent streamComponent = (StreamComponent)o;
        return this.name.equals(streamComponent.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "StreamComponent [name=" + this.name + ", contacts=" + this.contacts + ", repositoryType=" + (Object)((Object)this.repositoryType) + ", repositoryURL=" + this.repositoryURL + ", codebase=" + this.codebase + ", tag=" + this.tag + ", version=" + this.version + ", gav=" + this.gav + ", comment=" + this.comment + "]";
    }
}

