/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.util.Optional;

public class User {
    private final String email;
    private final String name;

    public static User createWithEmail(String email) {
        return new User(email, null);
    }

    public static User createWithUsername(String name) {
        return new User(null, name);
    }

    public User(String email, String name) {
        if (email == null && name == null) {
            throw new NullPointerException("A valid User object requires that one of the 'email' or 'name' fields are non-null.");
        }
        this.email = email;
        this.name = name;
    }

    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.email != null ? !this.email.equals(user.email) : user.email != null) {
            return false;
        }
        return this.name != null ? this.name.equals(user.name) : user.name == null;
    }

    public int hashCode() {
        int result = this.email != null ? this.email.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "User{email='" + this.email + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

