/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URI;

public enum RepositoryType {
    SVN,
    GIT,
    CVS,
    ARCHIVE,
    UNKNOWN;


    public static RepositoryType fromRepositoryURL(String stringURI) {
        if (stringURI.startsWith("git:") || stringURI.endsWith(".git") || stringURI.contains("github") || stringURI.contains("git.app")) {
            return GIT;
        }
        if (stringURI.startsWith("svn:") || stringURI.contains("svn") || stringURI.contains("trunk")) {
            return SVN;
        }
        if (stringURI.startsWith(":pserver:") || stringURI.contains("cvsroot")) {
            return CVS;
        }
        if (stringURI.endsWith(".jar") || stringURI.endsWith(".gz") || stringURI.endsWith(".zip")) {
            return ARCHIVE;
        }
        return UNKNOWN;
    }

    public static RepositoryType fromRepositoryURI(URI uri) {
        return RepositoryType.fromRepositoryURL(uri.toString());
    }

    public static RepositoryType fromType(String type) {
        if (type.toLowerCase().equals("git")) {
            return GIT;
        }
        if (type.toLowerCase().equals("svn")) {
            return SVN;
        }
        if (type.toLowerCase().equals("cvs")) {
            return CVS;
        }
        if (type.toLowerCase().equals("archive")) {
            return ARCHIVE;
        }
        return UNKNOWN;
    }
}

