/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.domain.StreamComponentUpdateException;

public class Stream {
    private final String name;
    private final Stream upstream;
    private final Map<String, StreamComponent> components;
    private final URL url;

    public Stream() {
        this("N/A");
    }

    public Stream(String name) {
        this(name, null);
    }

    public Stream(String name, Stream upstream) {
        this(null, name, upstream, new HashMap<String, StreamComponent>());
    }

    public Stream(URL url, String name, Stream upstream, Map<String, StreamComponent> components) {
        this.name = name;
        this.upstream = upstream;
        this.components = components;
        this.url = url;
        for (StreamComponent streamComponent : components.values()) {
            streamComponent.setStream(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasUpstream() {
        return this.upstream != null;
    }

    public Stream getUpstream() {
        return this.upstream;
    }

    public URL getURL() {
        return this.url;
    }

    public Collection<StreamComponent> getAllComponents() {
        return this.components.values();
    }

    public void addComponent(StreamComponent component) {
        this.components.put(component.getName(), component);
    }

    public void updateComponent(StreamComponent component) throws StreamComponentUpdateException {
        if (!this.components.containsKey(component.getName())) {
            throw new StreamComponentUpdateException(component);
        }
        this.components.put(component.getName(), component);
    }

    public StreamComponent getComponent(String componentName) {
        return this.components.get(componentName.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stream stream = (Stream)o;
        return this.name.equals(stream.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Stream{name='" + this.name + '\'' + ", upstream=" + (this.upstream != null ? this.upstream.getName() : "") + ",url=" + this.url + ", components=" + this.components + '}';
    }
}

